/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.IterableQueryStrategy;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.model.ConfigurableEquipment;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.ui.components.ComboItem;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllEquipmentManagerConfig
extends AbstractEquipmentManagerConfig {
    private static final Logger logger = Logger.getLogger(AbstractEquipmentManagerConfig.class);
    public static final Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AbstractEquipmentManagerConfig.class);
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public AllEquipmentManagerConfig(int maxSelection) {
        super(maxSelection);
        this.declaredActions = super.getDeclaredActions();
        this.defaultAction = super.getDefaultAction();
    }

    public AllEquipmentManagerConfig() {
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("New", 1));
        this.defaultAction = new AbstractEquipmentManagerConfig.EquipmentManagerAction("Configure", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("Edit", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("Delete", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("License", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("CutThrough", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("MultipleConfiguration", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("BackupConfiguration", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("Export", 1));
        this.declaredActions.add(new AbstractEquipmentManagerConfig.EquipmentManagerAction("OpenMap", 1));
        this.setTypeFilterCriteria(ConfigurableEquipment.class);
    }

    @Override
    protected String getBaseName() {
        return ConfigurableEquipment.class.getName();
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    protected void setTypeFilterCriteria(Class<?> baseClass) {
        String ATTR_TYPE = "CLASS";
        int typeIndex = -1;
        for (int i = 0; i < this.filterCriteria.size(); ++i) {
            if (!"CLASS".equals(((EntityManagerFilterCriteria)this.filterCriteria.get(i)).getAttribute())) continue;
            typeIndex = i;
            break;
        }
        Vector<Object> items = new Vector<Object>();
        try {
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedEquipment");
            if (null != extensionPoint) {
                for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
                    String equipmentClassName = element.getAttribute("class");
                    if (!baseClass.isAssignableFrom(Class.forName(equipmentClassName))) continue;
                    items.add(new ComboItem(equipmentClassName, ddI18N.translateString(equipmentClassName)));
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)"Configuration Error!", (Throwable)e);
            return;
        }
        EntityManagerFilterCriteria newTypeCriteria = new EntityManagerFilterCriteria(i18n.translateString("Type"), "CLASS", 2, 3, items, false);
        if (typeIndex < 0) {
            this.filterCriteria.add(1, newTypeCriteria);
        } else {
            this.filterCriteria.set(typeIndex, newTypeCriteria);
        }
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EquipmentManager");
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new IterableQueryStrategy();
    }
}

