/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.equipmentmanager;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.ddi.CutThroughNotSupportedException;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.configuration.ConfigApplicationPanel;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.editor.EntityTypeSelectorContainer;
import com.bwanms.gui.equipmentmanager.CommonAttributes;
import com.bwanms.gui.equipmentmanager.CommonAttributesSelectorView;
import com.bwanms.gui.equipmentmanager.EquipmentEditorContainer;
import com.bwanms.gui.equipmentmanager.EquipmentRowProvider;
import com.bwanms.gui.locationmanager.LocationMapAssembly;
import com.bwanms.gui.locationmanager.LocationMapEditorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.IconEntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.selectors.DefaultCancelAction;
import com.bwanms.gui.selectors.DefaultSelectAction;
import com.bwanms.gui.selectors.SelectorDialog;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.MultipleConfigTask;
import com.bwanms.model.ObjectID;
import com.bwanms.model.license.Licensable;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.InventoryManagementService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.CutThroughPluginUtil;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TaskPluginUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEquipmentManagerConfig
extends EntityManagerConfig {
    private static final Logger logger = Logger.getLogger(AbstractEquipmentManagerConfig.class);
    private static String[] COLUMN_NAMES = new String[]{"Name", "Type", "SoftwareVersion", "IPAddress", "Location", "State"};
    private static String[] COLUMN_ATTRIB_NAMES = new String[]{"Name", "", "FirmwareVersion", "IPAddress", "Location", "State"};
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(AbstractEquipmentManagerConfig.class);
    protected List<EntityManagerColumn> columns;
    protected EntityManagerRowProvider entityRowProvider;
    protected Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private DefaultSelectAction selectAction;
    private DefaultCancelAction cancelAction;

    public AbstractEquipmentManagerConfig(int maxSelection) {
        this.init();
        this.entityRowProvider = new EquipmentRowProvider(AbstractEquipmentManagerConfig.getColumnAttributeNames(this.columns));
        this.addFilterCriteria();
        this.declaredActions = new Vector<ManagerAction>();
        this.selectAction = new DefaultSelectAction(1, maxSelection);
        this.defaultAction = this.selectAction;
        this.declaredActions.add(this.defaultAction);
        this.cancelAction = new DefaultCancelAction(2);
        this.declaredActions.add(this.cancelAction);
    }

    public AbstractEquipmentManagerConfig() {
        this.init();
        this.entityRowProvider = new EquipmentRowProvider(AbstractEquipmentManagerConfig.getColumnAttributeNames(this.columns));
        this.addFilterCriteria();
    }

    @Override
    public ManagerResultsView getResultsView() {
        return new EntityManagerResultView(new IconEntityManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles(), this.getIconColIdx()){
            private static final long serialVersionUID = 8621736543199890828L;

            protected Icon getIcon(Serializable entity) {
                return UIIconFactory.getIcon(entity, 2);
            }
        }, this.getColumns());
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    protected DefaultSelectAction getSelectAction() {
        return this.selectAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        this.getSelectAction().setSelectionListener(selectorListener);
        this.cancelAction.setSelectionListener(selectorListener);
    }

    public void setMaxSelection(int maxSelection) {
        this.selectAction.setMaxSelection(maxSelection);
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EquipmentManager");
    }

    @Override
    public String getHelpTopic() {
        return "equipment_manager";
    }

    protected void addFilterCriteria() {
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("RunningSoftwareVersion"), "firmwareVersion", 1, 1, null, false));
        EntityManagerFilterCriteria ipAddrCriteria = new EntityManagerFilterCriteria(i18n.translateString("IPAddressRange"), "ipAddr", 3, 2, null, true, false);
        ipAddrCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            @Override
            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            selectedValues.set(i, new Long(new IpAddress(val).getIpAddress()));
                            if (i != 1 || (Long)selectedValues.get(i - 1) <= (Long)selectedValues.get(i)) continue;
                            throw new InvalidFilterValueException(val);
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add(ipAddrCriteria);
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Location"), "location.name", 1, 6, null, false));
        this.addStateFilterCriteria();
    }

    protected void init() {
        this.columns = new Vector<EntityManagerColumn>();
        this.columns.add(new EntityManagerColumn(COLUMN_NAMES[0], COLUMN_ATTRIB_NAMES[0], i18n.translateString(COLUMN_NAMES[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(COLUMN_NAMES[1], COLUMN_ATTRIB_NAMES[1], i18n.translateString(COLUMN_NAMES[1]), new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(COLUMN_NAMES[2], COLUMN_ATTRIB_NAMES[2], i18n.translateString(COLUMN_NAMES[2]), new EntityManagerRowComparator(2)));
        this.columns.add(new EntityManagerColumn(COLUMN_NAMES[3], COLUMN_ATTRIB_NAMES[3], i18n.translateString(COLUMN_NAMES[3]), new EntityManagerRowComparator(3)));
        this.columns.add(new EntityManagerColumn(COLUMN_NAMES[4], COLUMN_ATTRIB_NAMES[4], i18n.translateString(COLUMN_NAMES[4]), new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(COLUMN_NAMES[5], COLUMN_ATTRIB_NAMES[5], i18n.translateString(COLUMN_NAMES[5]), new EntityManagerRowDisplayComparator(5)));
    }

    protected void addStateFilterCriteria() {
        Vector<Object> items = new Vector<Object>();
        items.add(new ComboItem(-3, i18n.translateString("unknown")));
        items.add(new ComboItem(-1, i18n.translateString("unreachable")));
        items.add(new ComboItem(0, i18n.translateString("up")));
        items.add(new ComboItem(1, i18n.translateString("down")));
        items.add(new ComboItem(-5, i18n.translateString("unlicensed")));
        this.filterCriteria.add(new EquipmentStateManagerFilterCriteria(i18n.translateString("State"), "state", 1, 3, items, false));
    }

    protected int getIconColIdx() {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EquipmentManagerAction
    extends ManagerAction {
        private String equipmentType;

        public EquipmentManagerAction(String name, int category) {
            this(name, category, "Equipment");
        }

        public EquipmentManagerAction(String name, int category, String equipmentType) {
            this.name = name;
            this.category = category;
            this.equipmentType = equipmentType;
        }

        @Override
        public void performAction(final ManagerView manager) {
            Location location;
            MultipleConfigTask task;
            Class<?> tempcls;
            ArrayList<Equipment> equipments;
            IpAddress ip;
            ConfigApplicationView configAppView;
            Equipment equipment;
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                EntityTypeSelectorContainer typeSelectorContainer = new EntityTypeSelectorContainer(this.equipmentType, (JFrame)SwingUtilities.getWindowAncestor(manager.getUI()));
                typeSelectorContainer.showDialog();
                Class selectedType = typeSelectorContainer.getSelectedEntityType();
                if (null != selectedType) {
                    try {
                        EquipmentEditorContainer editorContainer = new EquipmentEditorContainer((Equipment)selectedType.newInstance(), null, (EntityChangeListener<Equipment>)((EntityChangeListener)((Object)manager)));
                    }
                    catch (InstantiationException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                    catch (ServiceException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }
            if ("Edit".equals(this.name)) {
                if (selection.isEmpty()) {
                    return;
                }
                try {
                    if (selection.size() == 1) {
                        if (manager instanceof EntityChangeListener) {
                            new EquipmentEditorContainer((Equipment)selection.get(0), null, (EntityChangeListener<Equipment>)((EntityChangeListener)((Object)manager)));
                        } else {
                            new EquipmentEditorContainer((Equipment)selection.get(0));
                        }
                    } else {
                        CommonAttributesSelectorView selector = new CommonAttributesSelectorView(){

                            public String getTitle() {
                                try {
                                    SelectorDialog dialog = (SelectorDialog)this.getUI().getTopLevelAncestor();
                                    dialog.getBtnSelect().setText(i18n.translateString("OK"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return super.getTitle();
                            }
                        };
                        SelectorUtil.displayModalSelector(manager.getUI(), selector);
                        final CommonAttributes commonAttributes = selector.getCommonAttributes();
                        if (commonAttributes != null && (commonAttributes.isUpdateLocation() || commonAttributes.isUpdateContact())) {
                            final EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
                            AbstractLongOperation updateOperation = new AbstractLongOperation(){

                                public String getTitle() {
                                    return i18n.translateString("UpdateCommonAttributesLongOpTitle");
                                }

                                public boolean isCancelable() {
                                    return true;
                                }

                                public long getMaxProgress() {
                                    return selection.size();
                                }

                                public void run() {
                                    long progress = 0L;
                                    boolean isUpdateLocation = commonAttributes.isUpdateLocation();
                                    HashSet<Location> locsToNotify = new HashSet<Location>();
                                    Location locationToNotify2 = commonAttributes.getLocation();
                                    locsToNotify.add(locationToNotify2);
                                    for (Serializable row : selection) {
                                        if (this.shouldCancel) {
                                            this.monitor.logMessage(i18n.translateString("Canceled"));
                                            break;
                                        }
                                        final Equipment eq = (Equipment)row;
                                        locsToNotify.add(eq.getLocation());
                                        if (isUpdateLocation) {
                                            eq.setLocation(locationToNotify2);
                                        }
                                        if (commonAttributes.isUpdateContact()) {
                                            eq.setContact(commonAttributes.getContact());
                                        }
                                        this.monitor.updateProgress(progress, i18n.translateString("UpdatingEquipment", eq.getName(), eq.getEUID()));
                                        try {
                                            try {
                                                entityService.save(eq);
                                            }
                                            catch (ServiceException e) {
                                                this.monitor.logMessage(i18n.translateString("ErrorUpdating", eq.getName(), eq.getEUID(), e.getMessage()));
                                                logger.debug((Object)e, (Throwable)e);
                                                if (++progress != this.getMaxProgress()) continue;
                                                this.monitor.updateProgress(progress, i18n.translateString("UpdatingEquipment", eq.getName(), eq.getEUID()));
                                                continue;
                                            }
                                            if (manager instanceof EntityChangeListener) {
                                                UIEventThread.syncExec(new Runnable(){

                                                    public void run() {
                                                        ((EntityChangeListener)((Object)manager)).entityChanged(eq);
                                                    }
                                                });
                                            }
                                            this.monitor.logMessage(i18n.translateString("SuccesfullyUpdated", eq.getName(), eq.getEUID()));
                                        }
                                        catch (Throwable t) {
                                            this.monitor.logMessage(i18n.translateString("ErrorUpdating", eq.getName(), eq.getEUID(), t.getMessage()));
                                            logger.info((Object)t, t);
                                        }
                                        this.monitor.updateProgress(++progress, i18n.translateString("UpdatingEquipment", eq.getName(), eq.getEUID()));
                                    }
                                    if (isUpdateLocation) {
                                        try {
                                            for (Location loc : locsToNotify) {
                                                if (loc == null) continue;
                                                ServiceRegistry.getTopologyManagerService().topologyChanged(new ObjectID(Location.class.getName(), Long.valueOf(loc.getId())));
                                            }
                                        }
                                        catch (Exception e) {
                                            logger.debug((Object)e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    this.monitor.operationCompleted(false);
                                }
                            };
                            LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), updateOperation);
                        }
                    }
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(null, ex.getMessage());
                }
            } else if ("Configure".equals(this.name)) {
                if (selection.isEmpty()) {
                    return;
                }
                equipment = (Equipment)selection.get(0);
                configAppView = new ConfigApplicationView(equipment, "Configuration");
                if (null == configAppView.getConfiguration()) {
                    throw new RuntimeException("Configuration does not exist for equipment with euid = " + equipment.getEUID());
                }
                ip = new IpAddress(equipment.getIpAddr());
                JFrame frame = FrameUtil.createModalFrame(null, true);
                FrameUtil.runFrame(frame, i18n.translateString("ConfiguringEquipment", equipment.getName(), ip.toString()), configAppView, 1024, 768, true);
            } else if ("Performance".equals(this.name)) {
                if (selection.isEmpty()) {
                    return;
                }
                equipment = (Equipment)selection.get(0);
                configAppView = new ConfigApplicationView(equipment, "Performance");
                if (null == configAppView.getConfiguration()) {
                    throw new RuntimeException("Performance does not exist for equipment with euid = " + equipment.getEUID());
                }
                ((ConfigApplicationPanel)configAppView.getUI()).getBtnApply().setVisible(false);
                ip = new IpAddress(equipment.getIpAddr());
                JFrame frame = FrameUtil.createModalFrame(null, true);
                FrameUtil.runFrame(frame, i18n.translateString("PerformanceEquipment", equipment.getName(), ip.toString()), configAppView, 1024, 768, true);
            } else if ("Delete".equals(this.name)) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                final EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteEquipment");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        for (final Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Equipment eq = (Equipment)row;
                            this.monitor.updateProgress(progress, i18n.translateString("DeletingEquipment", eq.getName(), eq.getEUID()));
                            try {
                                try {
                                    entityService.delete(eq);
                                    ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EquipmentDelete", "EquipmentManagement", eq.getName(), eq.getClass().getName());
                                }
                                catch (ServiceException e) {
                                    this.monitor.logMessage(i18n.translateString("ErrorDeleting", eq.getName(), eq.getEUID(), e.getMessage()));
                                    logger.debug((Object)e, (Throwable)e);
                                    if (++progress != this.getMaxProgress()) continue;
                                    this.monitor.updateProgress(progress, i18n.translateString("DeletingEquipment", eq.getName(), eq.getEUID()));
                                    continue;
                                }
                                if (manager instanceof EntityChangeListener) {
                                    UIEventThread.syncExec(new Runnable(){

                                        public void run() {
                                            ((EntityChangeListener)((Object)manager)).entityRemoved(row);
                                        }
                                    });
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", eq.getName(), eq.getEUID()));
                            }
                            catch (Throwable t) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeleting", eq.getName(), eq.getEUID(), t.getMessage()));
                                logger.debug((Object)t, t);
                            }
                            this.monitor.updateProgress(++progress, i18n.translateString("DeletingEquipment", eq.getName(), eq.getEUID()));
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("License".equals(this.name)) {
                final InventoryManagementService inventoryService = ServiceRegistry.getInventoryManagementService();
                AbstractLongOperation licenseOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("License");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Equipment eq = (Equipment)row;
                            if (!(eq instanceof Licensable)) {
                                if (++progress != this.getMaxProgress()) continue;
                                this.monitor.updateProgress(progress, i18n.translateString("LicensingEquipment", eq.getName(), eq.getEUID()));
                                continue;
                            }
                            if (eq instanceof Licensable && LicenseClient.getInstance().isLicensed(eq)) {
                                this.monitor.logMessage(i18n.translateString("AlreadyLicensed", eq.getName(), eq.getEUID()));
                                if (++progress != this.getMaxProgress()) continue;
                                this.monitor.updateProgress(progress, i18n.translateString("LicensingEquipment", eq.getName(), eq.getEUID()));
                                continue;
                            }
                            this.monitor.updateProgress(progress, i18n.translateString("LicensingEquipment", eq.getName(), eq.getEUID()));
                            try {
                                if (!inventoryService.licenseEquipment(eq.getId())) {
                                    this.monitor.logMessage(i18n.translateString("NoLicenseAvailable", eq.getName(), eq.getEUID()));
                                } else {
                                    this.monitor.logMessage(i18n.translateString("SuccesfullyLicensed", eq.getName(), eq.getEUID()));
                                }
                            }
                            catch (ServiceException e) {
                                this.monitor.logMessage(i18n.translateString("ErrorLicensing", eq.getName(), eq.getEUID(), e.getMessage()));
                                logger.debug((Object)e, (Throwable)e);
                            }
                            this.monitor.updateProgress(++progress, i18n.translateString("LicensingEquipment", eq.getName(), eq.getEUID()));
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), licenseOperation);
            } else if ("CutThrough".equals(this.name)) {
                try {
                    CutThroughPluginUtil.performCutThrough((Equipment)selection.get(0));
                }
                catch (CutThroughNotSupportedException e) {
                    MessageBox.Alert.quickShow(e.getMessage());
                }
                catch (Exception e) {
                    MessageBox.Error.quickShow("Failed to launch cut through!");
                }
            } else if ("MultipleConfiguration".equals(this.name)) {
                equipments = new ArrayList<Equipment>();
                tempcls = null;
                for (Serializable row : selection) {
                    Equipment eq = (Equipment)row;
                    equipments.add(eq);
                    if (tempcls != null) continue;
                    tempcls = eq.getClass();
                }
                if (tempcls != null) {
                    task = TaskPluginUtil.getMultipleConfigTask(tempcls);
                    task.setEquipments(equipments);
                    new TaskEditorFormContainer(task.getClass(), task);
                }
            } else if ("BackupConfiguration".equals(this.name)) {
                equipments = new ArrayList();
                tempcls = null;
                for (Serializable row : selection) {
                    Equipment eq = (Equipment)row;
                    equipments.add(eq);
                    if (tempcls != null) continue;
                    tempcls = eq.getClass();
                }
                if (tempcls != null) {
                    task = TaskPluginUtil.getConfigBackupTask(tempcls);
                    task.setEquipments(equipments);
                    new TaskEditorFormContainer(task.getClass(), task);
                }
            } else if ("Export".equals(this.name)) {
                File exportFile = FormUtil.getExportFile("csv", manager.getUI());
                if (exportFile != null) {
                    boolean overwriteExistingFile = false;
                    if (exportFile.exists() && !(overwriteExistingFile = MessageBox.WarnConfirm.showResult(manager.getUI(), i18n.translateString("ExportFileReplacingConfirmation", exportFile.getAbsolutePath()), i18n.translateString("ExportEquipmentTitle")))) {
                        logger.info((Object)i18n.translateString("ExportFileReplacingRejected", exportFile.getAbsolutePath()));
                        return;
                    }
                    try {
                        this.exportEquipments(((EntityManagerView)manager).getSelectionData(), exportFile);
                        logger.info((Object)i18n.translateString("EquipmentExported", selection.size(), exportFile.getAbsolutePath()));
                    }
                    catch (IOException e) {
                        logger.debug((Object)"Export equipments error", (Throwable)e);
                        MessageBox.Error.showResult(manager.getUI(), i18n.translateString("ExportEquipmentError", e.getMessage()), i18n.translateString("ExportEquipmentTitle"));
                    }
                }
            } else if ("OpenMap".equals(this.name) && (location = (equipment = (Equipment)selection.get(0)).getLocation()) != null) {
                try {
                    LocationMapAssembly assembley = (LocationMapAssembly)ServiceRegistry.getEntityManagerService().get(Location.class, location.getId(), "Editor");
                    if (assembley != null) {
                        LocationMapEditorContainer container = new LocationMapEditorContainer((Location)assembley.getEntity());
                    } else {
                        MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("LocationNotFound"));
                    }
                }
                catch (ServiceException e) {
                    logger.debug((Object)e);
                }
            }
        }

        private void exportEquipments(List<EntityManagerRow> selectedRows, File selectedFile) throws IOException {
            if (selectedRows == null || selectedRows.size() == 0 || selectedFile == null) {
                return;
            }
            if (!selectedFile.exists()) {
                selectedFile.createNewFile();
            }
            CSVWriter csvOut = new CSVWriter((Writer)new FileWriter(selectedFile));
            csvOut.writeNext(AbstractEquipmentManagerConfig.this.getColumnTitles());
            for (EntityManagerRow row : selectedRows) {
                csvOut.writeNext(row.getDisplayValues().toArray(new String[0]));
            }
            csvOut.close();
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("Configure")) {
                    if (selectionSize != 1) {
                        return false;
                    }
                    Equipment eq = (Equipment)selection.get(0);
                    return eq != null && eq.getFirmwareVersion() != null && !"".equals(eq.getFirmwareVersion()) && eq.getState() == 0 && LicenseClient.getInstance().isLicensed(eq);
                }
                if (this.name.equals("Performance")) {
                    if (selectionSize != 1) {
                        return false;
                    }
                    Equipment eq = (Equipment)selection.get(0);
                    return eq != null && eq.getFirmwareVersion() != null && !"".equals(eq.getFirmwareVersion()) && eq.getState() == 0 && LicenseClient.getInstance().isLicensed(eq);
                }
                if (this.name.equals("CutThrough")) {
                    if (selectionSize != 1) {
                        return false;
                    }
                    Equipment eq = (Equipment)selection.get(0);
                    return LicenseClient.getInstance().isLicensed(eq) && CutThroughPluginUtil.isCutThroughSupported(eq.getClass()) && eq.getState() == 0;
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                        return false;
                    }
                    return 0 < selectionSize;
                }
                if (this.name.equals("Edit")) {
                    if (selectionSize < 1) {
                        return false;
                    }
                    if (EditorPluginUtil.getViewForClass(selection.get(0).getClass()) == null) {
                        return false;
                    }
                    for (Serializable row : selection) {
                        if (LicenseClient.getInstance().isLicensed((Equipment)row)) continue;
                        return false;
                    }
                    return true;
                }
                if (this.name.equals("License")) {
                    for (Serializable row : selection) {
                        Equipment eq = (Equipment)row;
                        if (!(eq instanceof Licensable) || LicenseClient.getInstance().isLicensed(eq)) continue;
                        return true;
                    }
                    return false;
                }
                if (this.name.equals("MultipleConfiguration")) {
                    if (selectionSize < 1) {
                        return false;
                    }
                    String temp = null;
                    Equipment eq = (Equipment)selection.get(0);
                    Class<?> cls = eq.getClass();
                    temp = TaskPluginUtil.getMultipleConfigGroupForEquipment(cls);
                    if (temp == null) {
                        return false;
                    }
                    boolean tempTestEquipment = true;
                    for (Serializable row : selection) {
                        eq = (Equipment)row;
                        if (!temp.equals(TaskPluginUtil.getMultipleConfigGroupForEquipment(eq.getClass()))) {
                            return false;
                        }
                        tempTestEquipment = eq != null && eq.getFirmwareVersion() != null && !"".equals(eq.getFirmwareVersion()) && eq.getState() == 0 && LicenseClient.getInstance().isLicensed(eq);
                        if (tempTestEquipment) continue;
                        return tempTestEquipment;
                    }
                } else if (this.name.equals("BackupConfiguration")) {
                    if (selectionSize < 1) {
                        return false;
                    }
                    String temp = null;
                    Equipment eq = (Equipment)selection.get(0);
                    Class<?> cls = eq.getClass();
                    temp = TaskPluginUtil.getConfigBackupGroupForEquipment(cls);
                    if (temp == null) {
                        return false;
                    }
                    boolean tempTestEquipment = true;
                    for (Serializable row : selection) {
                        eq = (Equipment)row;
                        if (!temp.equals(TaskPluginUtil.getConfigBackupGroupForEquipment(eq.getClass()))) {
                            return false;
                        }
                        tempTestEquipment = eq != null && eq.getFirmwareVersion() != null && !"".equals(eq.getFirmwareVersion()) && eq.getState() == 0 && LicenseClient.getInstance().isLicensed(eq);
                        if (tempTestEquipment) continue;
                        return tempTestEquipment;
                    }
                } else {
                    if (this.name.equals("Export")) {
                        return selectionSize > 0;
                    }
                    if (this.name.equals("OpenMap")) {
                        if (selectionSize != 1) {
                            return false;
                        }
                        Equipment equipment = (Equipment)selection.get(0);
                        Location loc = equipment.getLocation();
                        return loc != null;
                    }
                }
            }
            return true;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EquipmentStateManagerFilterCriteria
    extends EntityManagerFilterCriteria {
        public EquipmentStateManagerFilterCriteria(String title, String attribute, int type, int uiType, Vector<Object> values, boolean negation) {
            super(title, attribute, type, uiType, values, negation);
        }

        @Override
        public ManagerFilterCriteriaView createView() {
            return new EntityManagerFilterCriteriaView(super.getName(), super.getTitle(), super.getJoinClass(), super.getAttribute(), super.getType(), super.getUiType(), super.getValues(), super.isNumeric(), super.isNegation()){

                public String getConditionToken(String alias) throws InvalidFilterValueException {
                    List<Object> selectedVals = super.getSelectedValues();
                    long activeLicenseId = LicenseClient.getInstance().getActiveLicenseId();
                    if (1 == selectedVals.size() && String.valueOf(-5).equals(selectedVals.get(0))) {
                        return alias + ".licenseID <> " + activeLicenseId;
                    }
                    return "(" + alias + ".licenseID = " + activeLicenseId + ") and (" + super.getConditionToken(alias) + ")";
                }
            };
        }
    }
}

