/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor.wizard;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.editor.wizard.EntityWizardEditorContainer;
import com.bwanms.gui.editor.wizard.EntityWizardPanel;
import com.bwanms.gui.help.HelpAction;
import com.bwanms.gui.help.HelpUtil;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityWizardEditorView
extends AbstractBindedEditorView<Serializable> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EntityWizardEditorView.class);
    private static final String BTN_BACK = "< Back";
    private static final String BTN_NEXT = "Next >";
    private static final String BTN_FINISH = "Finish";
    private static final String BTN_OK = "OK";
    private static final String BTN_CANCEL = "Cancel";
    private EntityWizardEditorContainer<?> container = null;
    private EntityWizardPanel panel = null;
    private InvalidValuesUtil invalidValuesUtil = new InvalidValuesUtil();
    private List<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
    private List<AbstractBindedEditorView<Serializable>> pageList = new ArrayList<AbstractBindedEditorView<Serializable>>();
    private int currentPage = 0;
    private boolean wizardMode = false;

    private EntityWizardEditorView() {
        this(null);
    }

    public EntityWizardEditorView(EntityWizardEditorContainer<?> container) {
        this.container = container;
        this.panel = new EntityWizardPanel();
        this.panel.getTabbedPane().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EntityWizardEditorView.this.tabbedPaneStateChanged(e);
            }
        });
        this.panel.getBtnHelp().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityWizardEditorView.this.btnHelpActionPerformed(e);
            }
        });
        this.panel.getBtnBack().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityWizardEditorView.this.btnBackActionPerformed(e);
            }
        });
        this.panel.getBtnNext().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityWizardEditorView.this.btnNextActionPerformed(e);
            }
        });
        this.panel.getBtnCancel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityWizardEditorView.this.btnCancelActionPerformed(e);
            }
        });
        this.panel.getBtnCancel().setText(i18n.translateString("wizard.cancel"));
        this.panel.getBtnHelp().setAction(new WizardHelpAction(this));
        this.panel.getBtnHelp().setText("");
        this.switchMode(true);
    }

    @Override
    public void setEntity(Serializable entity) {
        this.entity = entity;
        for (AbstractBindedEditorView<Serializable> page : this.pageList) {
            page.setEntity(entity);
        }
    }

    @Override
    public List<InvalidValue> configureEntity(Serializable entity) {
        LinkedList<InvalidValue> list = new LinkedList<InvalidValue>();
        for (AbstractBindedEditorView<Serializable> page : this.pageList) {
            list.addAll(page.configureEntity(entity));
        }
        return list;
    }

    @Override
    public void fillUI(Serializable entity) {
        for (AbstractBindedEditorView<Serializable> page : this.pageList) {
            if (!(page instanceof AbstractBindedEditorView)) continue;
            page.fillUI(entity);
        }
    }

    @Override
    public List<Binder> getBinders() {
        LinkedList<Binder> list = new LinkedList<Binder>();
        for (AbstractBindedEditorView<Serializable> page : this.pageList) {
            list.addAll(page.getBinders());
        }
        return list;
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        String topic = "";
        if (this.currentPage > -1 && this.currentPage < this.pageList.size()) {
            topic = this.pageList.get(this.currentPage).getHelpTopic();
        }
        return topic;
    }

    @Override
    public String getTitle() {
        return this.container.getTitle();
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    public boolean isWizardMode() {
        return this.wizardMode;
    }

    public void setWizardMode(boolean wizardMode) {
        this.wizardMode = wizardMode;
        if (this.wizardMode) {
            return;
        }
        this.switchMode(wizardMode);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 0 || currentPage >= this.pageList.size()) {
            throw new IllegalArgumentException("Current page is set out of range");
        }
        this.currentPage = currentPage;
        if (this.wizardMode) {
            JButton btnBack = this.panel.getBtnBack();
            JButton btnNext = this.panel.getBtnNext();
            if (this.isEmpty()) {
                btnBack.setEnabled(false);
                btnNext.setEnabled(false);
            } else {
                btnBack.setEnabled(!this.isFirstPage());
                btnBack.setText(i18n.translateString("wizard.back"));
                btnNext.setText(i18n.translateString(this.isLastPage() && !this.isFirstPage() ? "wizard.finish" : "wizard.next"));
            }
        } else if (!this.isEmpty()) {
            this.panel.getTabbedPane().setSelectedIndex(currentPage);
        }
    }

    public void addPage(AbstractBindedEditorView<Serializable> page) {
        this.pageList.add(page);
        if (this.wizardMode) {
            this.panel.getEditorPane().add((Component)page.getUI(), page.getTitle());
        } else {
            this.panel.getTabbedPane().add(page.getTitle(), page.getUI());
        }
        this.safePack();
    }

    @Override
    public final void processExternalInvalidValues(List<InvalidValue> invalidValues) {
        throw new UnsupportedOperationException("Not supported anymore");
    }

    private void tabbedPaneStateChanged(ChangeEvent e) {
        if (!this.wizardMode) {
            this.clearErrors();
            AbstractBindedEditorView<Serializable> editorView = this.pageList.get(this.currentPage);
            editorView.setEntity(this.entity);
            this.invalidValues = editorView.configureEntity(this.entity);
            if (this.invalidValues == null || this.invalidValues.size() == 0) {
                int index = this.panel.getTabbedPane().getSelectedIndex();
                if (index > -1) {
                    this.currentPage = index;
                    this.pageList.get(this.currentPage).fillUI(this.entity);
                }
            } else {
                this.panel.getTabbedPane().setSelectedIndex(this.currentPage);
                this.reportErrors();
            }
        }
    }

    private void btnHelpActionPerformed(ActionEvent e) {
    }

    private void btnBackActionPerformed(ActionEvent e) {
        if (this.wizardMode) {
            this.moveToPrevPage();
        }
    }

    private void btnNextActionPerformed(ActionEvent e) {
        if (this.wizardMode) {
            if (this.isLastPage()) {
                this.finish();
            } else {
                this.moveToNextPage();
            }
        } else {
            this.finish();
        }
    }

    private void moveToNextPage() {
        this.clearErrors();
        this.invalidValues = this.pageList.get(this.currentPage).configureEntity(this.entity);
        if (this.invalidValues == null || this.invalidValues.size() == 0) {
            JPanel contentPanel = this.panel.getEditorPane();
            ((CardLayout)contentPanel.getLayout()).next(contentPanel);
            ++this.currentPage;
            this.pageList.get(this.currentPage).fillUI(this.entity);
            this.panel.getBtnBack().setEnabled(this.currentPage > 0);
            this.panel.getBtnNext().setText(i18n.translateString(this.isLastPage() ? "wizard.finish" : "wizard.next"));
        } else {
            this.reportErrors();
        }
    }

    private void moveToPrevPage() {
        this.clearErrors();
        if (this.invalidValues == null || this.invalidValues.size() == 0) {
            JPanel contentPanel = this.panel.getEditorPane();
            ((CardLayout)contentPanel.getLayout()).previous(contentPanel);
            --this.currentPage;
            this.pageList.get(this.currentPage).fillUI(this.entity);
            this.panel.getBtnBack().setEnabled(this.currentPage > 0);
            this.panel.getBtnNext().setText(i18n.translateString(this.isLastPage() ? "wizard.finish" : "wizard.next"));
        } else {
            this.reportErrors();
        }
    }

    private void finish() {
        this.clearErrors();
        List<InvalidValue> list = this.invalidValues = !this.wizardMode ? this.configureEntity(this.entity) : this.pageList.get(this.currentPage).configureEntity(this.entity);
        if (this.invalidValues == null || this.invalidValues.size() == 0) {
            try {
                this.container.saveEntity();
                this.container.cleanup();
            }
            catch (ServerValidationException e) {
                this.invalidValues = e.getInvalidValues();
                this.reportErrors();
            }
            catch (Exception ex) {
                MessageBox.Error.quickShow(this.panel, i18n.translateString("EntitySaveError", this.container.getEntityName()));
                this.container.cleanup();
            }
        } else {
            this.reportErrors();
        }
    }

    private void reportErrors() {
        this.panel.getErrorPane().setMessages(this.invalidValues);
        this.invalidValuesUtil.reportInvalidValues(this.invalidValues);
    }

    private void clearErrors() {
        this.invalidValuesUtil.clearReportedInvalidValues(this.invalidValues);
        this.panel.getErrorPane().setMessages(this.invalidValues);
    }

    private void btnCancelActionPerformed(ActionEvent e) {
        this.container.cleanup();
    }

    private boolean isEmpty() {
        return this.pageList.isEmpty();
    }

    private boolean isFirstPage() {
        return this.currentPage == 0;
    }

    private boolean isLastPage() {
        return this.currentPage == this.pageList.size() - 1;
    }

    private void switchMode(boolean wizardMode) {
        JTabbedPane tabbedPane = this.panel.getTabbedPane();
        JPanel contentPane = this.panel.getEditorPane();
        JButton btnBack = this.panel.getBtnBack();
        JButton btnNext = this.panel.getBtnNext();
        JLabel image = this.panel.getImage();
        if (wizardMode) {
            tabbedPane.setEnabled(false);
            tabbedPane.setVisible(false);
            tabbedPane.removeAll();
            image.setVisible(true);
            for (AbstractBindedEditorView<Serializable> page : this.pageList) {
                contentPane.add((Component)page.getUI(), page.getTitle());
            }
            if (!this.isEmpty()) {
                ((CardLayout)contentPane.getLayout()).show(contentPane, this.pageList.get(this.currentPage).getTitle());
            }
            contentPane.setEnabled(true);
            contentPane.setVisible(true);
            btnBack.setVisible(true);
            btnBack.setEnabled(!this.isEmpty() && this.currentPage > 0);
            btnBack.setText(i18n.translateString("wizard.back"));
            btnNext.setText(i18n.translateString(!this.isEmpty() && this.isLastPage() ? "wizard.next" : "wizard.finish"));
        } else {
            contentPane.setEnabled(false);
            contentPane.setVisible(false);
            contentPane.removeAll();
            image.setVisible(false);
            for (AbstractBindedEditorView<Serializable> page : this.pageList) {
                tabbedPane.add(page.getTitle(), page.getUI());
            }
            if (!this.isEmpty()) {
                tabbedPane.setSelectedIndex(this.currentPage);
            }
            tabbedPane.setEnabled(true);
            tabbedPane.setVisible(true);
            btnBack.setEnabled(false);
            btnBack.setVisible(false);
            btnNext.setText(i18n.translateString("wizard.ok"));
        }
        this.wizardMode = wizardMode;
        this.safePack();
    }

    private void safePack() {
        JFrame frame;
        if (this.container != null && (frame = this.container.getFrame()) != null) {
            frame.pack();
        }
    }

    private static class WizardHelpAction
    extends HelpAction {
        private EntityWizardEditorView view;

        private WizardHelpAction(String helpTopic) {
            super(helpTopic);
        }

        public WizardHelpAction(EntityWizardEditorView view) {
            super(view.getHelpTopic());
            this.view = view;
        }

        public void actionPerformed(ActionEvent e) {
            HelpUtil.getInstance().showHelp(this.view.getHelpTopic());
        }
    }
}

