/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor.wizard;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.editor.EditorFrameUtil;
import com.bwanms.gui.editor.wizard.EntityWizardEditorView;
import com.bwanms.gui.editor.wizard.EntityWizardPanel;
import com.bwanms.model.Identifiable;
import com.bwanms.model.Task;
import com.bwanms.model.TaskObserver;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.util.FrameUtil;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityWizardEditorContainer<T extends Serializable>
implements TaskObserver {
    protected JFrame frame;
    protected T entity;
    protected EntityWizardEditorView view;
    protected InvalidValuesUtil invalidValuesUtil;
    protected List<InvalidValue> invalidValues;

    public EntityWizardEditorContainer(T entity) throws Exception {
        this(entity, null, true);
    }

    public EntityWizardEditorContainer(T entity, Window owner) throws Exception {
        this(entity, owner, true);
    }

    public EntityWizardEditorContainer(T entity, Window owner, boolean returnImmediately) throws Exception {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        try {
            this.entity = this.loadEntity(entity);
        }
        catch (ServiceException ex) {
            throw new ServiceException("com.bwanms.gui.editor.EntityEditorContainer", "EntityLoadingError");
        }
        if (this.entity == null) {
            throw new ServiceException("com.bwanms.gui.editor.EntityEditorContainer", "EntityNotFoundError", (Serializable[])new String[]{this.getEntityClass()});
        }
        this.invalidValues = new ArrayList<InvalidValue>();
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.view = new EntityWizardEditorView(this);
        this.view.setEntity((Serializable)this.entity);
        this.frame = FrameUtil.createModalFrame(owner, returnImmediately);
        this.frame.getContentPane().add(this.view.getUI());
        this.frame.setResizable(false);
        this.view.setWizardMode(true);
        ((EntityWizardPanel)this.view.getUI()).getErrorPane().setTitle(this.getTitle());
    }

    public EntityWizardEditorContainer() throws ServiceException {
        this(null, true);
    }

    public EntityWizardEditorContainer(Window owner) throws ServiceException {
        this(owner, true);
    }

    public EntityWizardEditorContainer(Window owner, boolean returnImmediately) throws ServiceException {
        this.invalidValues = new ArrayList<InvalidValue>();
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.view = new EntityWizardEditorView(this);
        this.view.setEntity((Serializable)this.entity);
        this.frame = FrameUtil.createModalFrame(owner, returnImmediately);
        this.frame.getContentPane().add(this.view.getUI());
        this.frame.setResizable(true);
        this.view.setWizardMode(true);
        ((EntityWizardPanel)this.view.getUI()).getErrorPane().setTitle(this.getTitle());
    }

    public void addPage(AbstractBindedEditorView page) {
        this.view.addPage(page);
        this.frame.pack();
    }

    public void addPages(AbstractBindedEditorView<Serializable>[] pages) {
        for (AbstractBindedEditorView<Serializable> page : pages) {
            this.view.addPage(page);
        }
        this.frame.pack();
    }

    public void addPages(Collection<AbstractBindedEditorView<Serializable>> pages) {
        for (AbstractBindedEditorView<Serializable> page : pages) {
            this.view.addPage(page);
        }
        this.frame.pack();
    }

    public void runEditor() {
        this.view.fillUI((Serializable)this.entity);
        this.view.setCurrentPage(0);
        Long entityId = this.getEntityId();
        EditorFrameUtil.runEditorFrame(this.entity.getClass(), null == entityId ? null : entityId.toString(), this);
    }

    public void runEditorNoEntity() {
        this.view.setCurrentPage(0);
        EditorFrameUtil.runEditorFrame(null, null, this);
    }

    public boolean isWizardMode() {
        return this.view.isWizardMode();
    }

    public void setWizardMode(boolean wizardMode) {
        this.view.setWizardMode(wizardMode);
        this.frame.pack();
    }

    protected T loadEntity(T entity) throws Exception {
        long taskId;
        if (entity instanceof Task && (taskId = ((Task)entity).getId()) > 0L) {
            return (T)ServiceRegistry.getTaskManagerService().retrieveTask(taskId);
        }
        if (entity instanceof Identifiable && ((Identifiable)entity).getId() > 0L) {
            return (T)ServiceRegistry.getEntityManagerService().get(entity.getClass(), ((Identifiable)entity).getId());
        }
        return entity;
    }

    protected void saveEntity() throws Exception {
        EntityManagerService entityManagerService = ServiceRegistry.getEntityManagerService();
        entityManagerService.save(this.entity);
    }

    public void cleanup() {
        if (this.view != null) {
            this.view.cleanup();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public abstract Long getEntityId();

    public abstract String getEntityClass();

    public abstract String getEntityName();

    public abstract String getTitle();

    public JFrame getFrame() {
        return this.frame;
    }
}

