/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor;

import com.bwanms.gui.Preview;
import com.bwanms.gui.editor.PreviewContainerPanel;
import com.bwanms.services.impl.EntityPersistenceInterpretor;
import com.bwanms.util.FrameUtil;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreviewContainer<T> {
    private static final Logger log = Logger.getLogger(PreviewContainer.class);
    protected EntityPersistenceInterpretor persistenceStrategy;
    private final JFrame frame;
    protected PreviewContainerPanel form = new PreviewContainerPanel(this);
    protected Preview<T> view;

    public PreviewContainer(T entity, Object ... data) {
        this(entity, false, data);
    }

    public PreviewContainer(T entity, boolean loadEntity, Object ... data) {
        if (loadEntity) {
            entity = this.loadEntity(entity);
        }
        this.view = this.initPreview(entity, data);
        this.view.setEntity(entity);
        this.form.setInternalPanel(this.view.getUI());
        this.frame = FrameUtil.createFrame();
        this.frame.getContentPane().add(this.form);
        this.frame.getRootPane().setDefaultButton(this.form.getDefaultButton());
        this.frame.pack();
        FrameUtil.runFrame(this.frame, this.view.getTitle(), false);
    }

    protected void show() {
        FrameUtil.runFrame(this.frame, this.view.getTitle(), false);
    }

    protected T loadEntity(T entity) {
        return entity;
    }

    public PreviewContainerPanel getForm() {
        return this.form;
    }

    public void closeFrame() {
        this.frame.dispose();
    }

    public abstract Preview<T> initPreview(T var1, Object ... var2);

    public abstract String getTitle();

    public void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
        this.frame.validate();
    }

    public void setMaxSize(Dimension maxSize) {
        this.frame.setSize(maxSize.width, maxSize.height);
        FrameUtil.centerWindow(this.frame);
        this.frame.validate();
    }
}

