/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EditorFrameUtil;
import com.bwanms.gui.editor.EditorPluginUtil;
import com.bwanms.gui.editor.EntityTypeSelectorForm;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class EntityTypeSelectorContainer {
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.ddi");
    private String entityName;
    private String dialogTitle;
    private JDialog selectionDialog;
    private EntityTypeSelectorForm form;
    private List<String> entityTypes;
    private Class selectedEntityType;

    public EntityTypeSelectorContainer(String entityName, JFrame parentFrame) {
        this.entityName = entityName;
        this.selectionDialog = new JDialog(parentFrame);
    }

    public EntityTypeSelectorContainer(String entityName, JFrame parentFrame, String dialogTitle) {
        this.entityName = entityName;
        this.dialogTitle = dialogTitle;
        this.selectionDialog = new JDialog(parentFrame);
    }

    public Class getSelectedEntityType() {
        return this.selectedEntityType;
    }

    public JDialog getSelectionDialog() {
        return this.selectionDialog;
    }

    public void showDialog() {
        this.form = new EntityTypeSelectorForm(this);
        this.selectionDialog.getRootPane().setDefaultButton(this.form.getDefaultButton());
        this.entityTypes = EditorPluginUtil.getEntityTypes(this.entityName);
        Vector<String> comboBoxItems = new Vector<String>();
        for (String entityType : this.entityTypes) {
            comboBoxItems.add(ddI18N.translateString(entityType));
        }
        this.form.getComboEntityType().setModel(new DefaultComboBoxModel(comboBoxItems));
        EditorFrameUtil.runTypeSelectorDialog(this.dialogTitle == null ? ddI18N.translateString(this.entityName) : this.dialogTitle, this.form, 0, 0, this);
    }

    public void actionOKPerformed() {
        String selectedClassName = this.entityTypes.get(this.form.getComboEntityType().getSelectedIndex());
        try {
            this.selectedEntityType = Class.forName(selectedClassName);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        this.selectionDialog.setVisible(false);
    }

    public void actionCancelPerformed() {
        this.selectedEntityType = null;
        this.selectionDialog.setVisible(false);
    }

    public void cleanup() {
        this.selectionDialog = null;
        this.form = null;
    }
}

