/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.EditorViewContext;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EditorFrameUtil;
import com.bwanms.gui.editor.EntityEditorForm;
import com.bwanms.gui.help.HelpAction;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.Identifiable;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.EntityPersistenceInterpretor;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityEditorContainer<T extends Serializable>
implements EditorViewContext<T> {
    private static final Logger log = Logger.getLogger(EntityEditorContainer.class);
    private static final String platformType = System.getProperty("com.bwanms.platform", "remote");
    protected EntityPersistenceInterpretor persistenceStrategy;
    protected JFrame frame;
    protected T entity;
    protected EntityEditorForm form;
    protected EditorView<T> view;
    protected InvalidValuesUtil invalidValuesUtil;
    protected List<InvalidValue> invalidValues;
    protected boolean entityIsNew = false;
    protected EntityChangeListener<Serializable> listener;

    public EntityEditorContainer(T entity, EntityChangeListener<Serializable> listener) throws ServiceException {
        this(entity, null, true);
        this.listener = listener;
    }

    public EntityEditorContainer(T entity) throws ServiceException {
        this(entity, null, true);
    }

    public EntityEditorContainer(T entity, Window owner) throws ServiceException {
        this(entity, owner, true);
    }

    public EntityEditorContainer(T entity, Window owner, boolean returnImmediately) throws ServiceException {
        try {
            this.entity = this.loadEntity(entity);
        }
        catch (ServiceException ex) {
            throw new ServiceException("com.bwanms.gui.editor.EntityEditorContainer", "EntityLoadingError");
        }
        if (this.entity == null) {
            throw new ServiceException("com.bwanms.gui.editor.EntityEditorContainer", "EntityNotFoundError", (Serializable[])new String[]{this.getEntityClass()});
        }
        this.invalidValues = new ArrayList<InvalidValue>();
        this.form = new EntityEditorForm(this);
        this.setEntity(this.entity);
        this.view = this.initView();
        this.view.setEntity(this.entity);
        this.view.setEntityContext(this);
        JButton defaultButton = this.form.getDefaultButton();
        if (!Security.getSecurity().checkPermissions(this.view.getApplicationPermission(), "write")) {
            defaultButton.setEnabled(false);
        }
        this.form.setInternalPanel(this.view.getUI());
        this.form.getErrorReportEditorPane1().setTitle(this.view.getTitle());
        this.form.getBtnHelp().setVisible(true);
        this.form.getBtnHelp().setAction(new HelpAction(this.view.getHelpTopic()));
        this.form.getBtnHelp().setText("");
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.frame = FrameUtil.createModalFrame(owner, returnImmediately);
        this.frame.getContentPane().add(this.form);
        this.frame.getRootPane().setDefaultButton(this.form.getDefaultButton());
        this.frame.pack();
        this.frame.setResizable(false);
        EditorFrameUtil.runEditorFrame(this.entity.getClass(), this.getEntityId(), this);
    }

    protected T loadEntity(T entity) throws ServiceException {
        if (entity instanceof Identifiable && ((Identifiable)entity).getId() > 0L) {
            return (T)ServiceRegistry.getEntityManagerService().get(entity.getClass(), ((Identifiable)entity).getId());
        }
        this.entityIsNew = true;
        return entity;
    }

    public void actionOKPerformed() {
        if (this.save() != null) {
            this.cleanup();
        }
    }

    @Override
    public final T save() {
        this.invalidValuesUtil.clearReportedInvalidValues(this.invalidValues);
        this.invalidValues = this.view.configureEntity(this.getEntity());
        this.reportErrors();
        if (this.invalidValues.isEmpty()) {
            try {
                if (!this.beforeSave()) {
                    return null;
                }
                this.saveEntity();
                return this.entity;
            }
            catch (ServerValidationException e) {
                this.invalidValues = e.getInvalidValues();
                this.view.processExternalInvalidValues(this.invalidValues);
                this.reportErrors();
            }
            catch (Exception ex) {
                log.error((Object)"Error saving entity", (Throwable)ex);
                Internationalizer i18n = Internationalizer.getInternationalizer("com.bwanms.gui.editor.EntityEditorContainer");
                MessageBox.Error.quickShow(this.form, i18n.translateString("EntitySaveError", this.getEntityName()));
            }
        }
        return null;
    }

    protected boolean beforeSave() {
        return true;
    }

    protected void reportErrors() {
        this.form.getErrorReportEditorPane1().setMessages(this.invalidValues);
        this.invalidValuesUtil.reportInvalidValues(this.invalidValues);
    }

    protected void saveEntity() throws ServiceException {
        T entity = ServiceRegistry.getEntityManagerService().save(this.getEntity());
        if (this.listener != null) {
            if (this.entityIsNew) {
                this.listener.entityAdded((Serializable)entity);
            } else {
                this.listener.entityChanged((Serializable)entity);
            }
        }
    }

    public EntityEditorForm getForm() {
        return this.form;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void closeFrame() {
        this.frame.dispose();
    }

    public EditorView<T> getView() {
        return this.view;
    }

    public void actionCancelPerformed() {
        this.cleanup();
    }

    public void cleanup() {
        if (this.view != null) {
            this.view.cleanup();
        }
        this.getFrame().dispose();
    }

    public abstract String getEntityId();

    protected abstract String getEntityClass();

    protected abstract String getEntityName();

    protected abstract EditorView<T> initView();

    public abstract String getTitle();

    protected void setEntity(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Can't set entity to null.");
        }
        this.entity = entity;
    }

    protected T getEntity() {
        return this.entity;
    }
}

