/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.EditorView;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPluginUtil {
    private static final Logger log;
    private static Map<String, List<String>> availableTypes;
    private static Map<String, Class<AbstractBindedEditorView>> availableViewTypes;

    public static List<String> getEntityTypes(String entityName) {
        return availableTypes.get(entityName);
    }

    public static EditorView getViewForClass(Class entityClass) {
        Class<AbstractBindedEditorView> editorViewClass = null;
        for (Class c = entityClass; null == editorViewClass && null != c; c = c.getSuperclass()) {
            editorViewClass = availableViewTypes.get(c.getName());
        }
        if (null != editorViewClass) {
            try {
                return (EditorView)editorViewClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        int i;
        IConfigurationElement[] configElements;
        log = Logger.getLogger(EditorPluginUtil.class);
        log.debug((Object)"EditorPluginUtil init.");
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        availableTypes = new HashMap<String, List<String>>();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedEditor");
        for (IExtension extension : extensionPoint.getExtensions()) {
            configElements = extension.getConfigurationElements();
            for (i = 0; i < configElements.length; ++i) {
                String entityName = configElements[i].getAttribute("name");
                List<String> entityClasses = availableTypes.get(entityName);
                if (null == entityClasses) {
                    entityClasses = new Vector<String>();
                    availableTypes.put(entityName, entityClasses);
                }
                entityClasses.add(configElements[i].getAttribute("class"));
            }
        }
        availableViewTypes = new HashMap<String, Class<AbstractBindedEditorView>>();
        extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.editor");
        for (IExtension extension : extensionPoint.getExtensions()) {
            configElements = extension.getConfigurationElements();
            for (i = 0; i < configElements.length; ++i) {
                try {
                    availableViewTypes.put(configElements[i].getAttribute("class"), Class.forName(configElements[i].getAttribute("viewClass")));
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    log.error((Object)("Class not found " + configElements[i].getAttribute("viewClass") + " for class " + configElements[i].getAttribute("class")));
                    cnfe.printStackTrace();
                }
            }
        }
    }
}

