/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.editor;

import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.editor.EntityTypeSelectorContainer;
import com.bwanms.gui.editor.wizard.EntityWizardEditorContainer;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorFrameUtil {
    private static final Logger log = Logger.getLogger(EditorFrameUtil.class);
    private static Map<Class, Map<String, Window>> activeEditorFrames = new HashMap<Class, Map<String, Window>>();

    public static void runEditorFrame(Class entityClass, String entityId, EntityEditorContainer<? extends Object> container) {
        EditorFrameUtil.runEditorFrame(entityClass, entityId, "", container);
    }

    public static void runEditorFrame(final Class entityClass, final String entityId, String title, final EntityEditorContainer<? extends Object> container) {
        Window activeFrame = null;
        if (null != entityId) {
            Map<String, Window> activeEditorFramesForClass = activeEditorFrames.get(entityClass);
            if (null == activeEditorFramesForClass) {
                activeEditorFramesForClass = new HashMap<String, Window>();
                activeEditorFrames.put(entityClass, activeEditorFramesForClass);
                log.debug((Object)("Created activeEditorFrames Map for " + entityClass));
            } else {
                activeFrame = activeEditorFramesForClass.get(entityId);
            }
        }
        if (null == activeFrame) {
            final JFrame frame = container.getFrame();
            if (title != null && !title.equals("")) {
                frame.setTitle(title);
            } else {
                frame.setTitle(container.getTitle());
            }
            frame.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    if (null != entityId) {
                        ((Map)activeEditorFrames.get(entityClass)).put(entityId, frame);
                    }
                }

                public void windowClosing(WindowEvent e) {
                    container.cleanup();
                }

                public void windowClosed(WindowEvent e) {
                    if (null != entityId) {
                        ((Map)activeEditorFrames.get(entityClass)).remove(entityId);
                    }
                }
            });
            int width = frame.getWidth();
            int height = frame.getHeight();
            int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
            int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
            frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
            activeFrame = frame;
        }
        if (activeFrame instanceof JFrame) {
            ((JFrame)activeFrame).setState(0);
        }
        activeFrame.setVisible(true);
    }

    public static void runEditorFrame(final Class entityClass, final String entityId, final EntityWizardEditorContainer<? extends Object> container) {
        Window activeFrame = null;
        if (null != entityId) {
            Map<String, Window> activeEditorFramesForClass = activeEditorFrames.get(entityClass);
            if (null == activeEditorFramesForClass) {
                activeEditorFramesForClass = new HashMap<String, Window>();
                activeEditorFrames.put(entityClass, activeEditorFramesForClass);
                log.debug((Object)("Created activeEditorFrames Map for " + entityClass));
            } else {
                activeFrame = activeEditorFramesForClass.get(entityId);
            }
        }
        if (null == activeFrame) {
            final JFrame frame = container.getFrame();
            String title = container.getTitle();
            if (title != null && !title.equals("")) {
                frame.setTitle(title);
            } else {
                frame.setTitle(container.getTitle());
            }
            frame.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    if (null != entityId) {
                        ((Map)activeEditorFrames.get(entityClass)).put(entityId, frame);
                    }
                }

                public void windowClosing(WindowEvent e) {
                    container.cleanup();
                }

                public void windowClosed(WindowEvent e) {
                    if (null != entityId) {
                        ((Map)activeEditorFrames.get(entityClass)).remove(entityId);
                    }
                }
            });
            int width = frame.getWidth();
            int height = frame.getHeight();
            int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
            int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
            frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
            activeFrame = frame;
        }
        if (activeFrame instanceof JFrame) {
            ((JFrame)activeFrame).setState(0);
        }
        activeFrame.setVisible(true);
    }

    public static void runTypeSelectorDialog(String title, JComponent component, int width, int height, final EntityTypeSelectorContainer container) {
        JDialog dialog = container.getSelectionDialog();
        dialog.setTitle(title);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                container.cleanup();
                super.windowClosing(e);
            }
        });
        dialog.getContentPane().add(component);
        if (0 < width && 0 < height) {
            dialog.setSize(width, height);
        } else {
            dialog.pack();
        }
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setModal(true);
        dialog.setVisible(true);
    }
}

