/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.contactmanager;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.contactmanager.ContactEditorContainer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.Contact;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(ContactManagerConfig.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(ContactManagerConfig.class);
    private static String[] columnNames = new String[]{"ContactId", "FirstName", "LastName", "Company"};
    private static String[] columnAttribNames = new String[]{"ContactId", "FirstName", "LastName", "Company"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private boolean isMultipleSelection = false;

    public ContactManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), new EntityManagerRowDisplayComparator(3)));
        this.entityRowProvider = new ContactManagerRowProvider(ContactManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("ContactId"), "contactId", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("FirstName"), "firstName", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("LastName"), "lastName", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Company"), "company", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new ContactManagerAction("New", 1));
        this.defaultAction = new ContactManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new ContactManagerAction("Delete", 1));
    }

    public ContactManagerConfig(String userData) {
        this();
        if (userData != null && userData.equals("multipleSelection")) {
            this.isMultipleSelection = true;
        }
    }

    @Override
    protected String getBaseName() {
        return Contact.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.remove(0);
        }
        this.defaultAction = new ContactManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
    }

    @Override
    public String getTitle() {
        return i18n.translateString("ContactManager");
    }

    @Override
    public String getHelpTopic() {
        return "contacts";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContactManagerRowProvider
    extends DefaultRowCreator {
        public ContactManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((Contact)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContactManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public ContactManagerAction(String name, int category) {
            this(name, category, null);
        }

        public ContactManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                try {
                    new ContactEditorContainer(new Contact(), (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Open".equals(this.name) && 1 == selection.size()) {
                Contact contact = (Contact)selection.get(0);
                try {
                    new ContactEditorContainer(contact, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityManagerService contactService = ServiceRegistry.getEntityManagerService();
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Contact contact = (Contact)row;
                            String contactId = contact.getContactId();
                            String message = i18n.translateString("DeletingContact", contactId);
                            this.monitor.updateProgress(progress, message);
                            try {
                                contactService.delete(contact);
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", contactId));
                                log.debug((Object)("Deleted contact: " + contactId));
                            }
                            catch (ServerValidationException e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", contactId, e.getInvalidValues().get(0).getMessage()));
                                log.debug((Object)"Failed to delete contact.", (Throwable)e);
                            }
                            catch (Exception e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", contactId, e.getMessage()));
                                log.debug((Object)"Failed to delete contact.", (Throwable)e);
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("Select".equals(this.name) && (ContactManagerConfig.this.isMultipleSelection || 1 == selection.size())) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("New")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureContacts", "add")) {
                    return false;
                }
            } else {
                if (this.name.equals("Open")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    if (!Security.getSecurity().checkPermissions("Av:ConfigureContacts", "delete")) {
                        return false;
                    }
                    return selectionSize > 0;
                }
                if (this.name.equals("Select")) {
                    if (ContactManagerConfig.this.isMultipleSelection) {
                        return selectionSize > 0;
                    }
                    return 1 == selectionSize;
                }
            }
            return true;
        }
    }
}

