/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration.pm;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ActionCommandCallback;
import com.bwanms.gui.configuration.CommandCallback;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.LongActionCallback;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupport;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.gui.configuration.ManagedObjectsConfigFormContext;
import com.bwanms.gui.configuration.pm.ManagedObjectRequestCounterProvider;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringPanel;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringViewCounterProvider;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.performance.viewer.CounterSelectorTreePanel3;
import com.bwanms.performance.viewer.CounterSelectorTreeView3;
import com.bwanms.performance.viewer.MultiGraphDataDisplayView;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.EquipmentAgentException;
import com.bwanms.services.EquipmentCommunicationException;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.FrameUtil;
import com.ngnms.apps.pmcollection.AvMultiCounterGraphData;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.AvPMCounterNodeUtil;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvPMCounterSelectorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerformanceMonitoringSectionView
implements ConfigSectionView,
ManagedObjectsConfigFormContext,
ActionCommandCallback,
CommandCallback,
IAvPMCounterSelectorListener {
    private static final Logger logger = Logger.getLogger(PerformanceMonitoringSectionView.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(PerformanceMonitoringSectionView.class);
    protected PerformanceMonitoringPanel pmPanel;
    private CounterSelectorTreeView3 counterSelectorView;
    private MultiGraphDataDisplayView dataDisplayView;
    private PerformanceMonitoringViewCounterProvider counterProvider;
    protected ManagedObjectsAccessSupport managedObjectsAccessSupport;
    protected LongActionCallback longActionCallback;
    protected boolean shouldStop = false;
    private Integer pollingInterval = 5000;
    private boolean mosValid = false;
    private double holeValue;
    private Thread refreshThread;
    private Object refreshThreadLock = new Object();
    private long lastRefreshTime = 0L;
    private static final LongActionCallback nullLongActionCallback = new LongActionCallback(){

        public void onStarting(String message) {
        }

        public void onFinished(String message) {
        }
    };
    private String title;
    protected Equipment equipment;
    private HashMap<String, Object> attributes;
    private ActionCommandCallback actionCommandCallback;
    private CommandCallback commandCallback;
    private Hashtable<String, Vector> selectedCounters = new Hashtable();
    private Vector<String> selectedCounterIDs = new Vector();
    private Vector<String> hiddenCounters = new Vector();

    public PerformanceMonitoringSectionView() {
        this.attributes = new HashMap();
        this.managedObjectsAccessSupport = new ManagedObjectsAccessSupport(new MOAccessCallback());
    }

    @Override
    public JComponent getUI() {
        if (this.pmPanel == null) {
            this.pmPanel = new PerformanceMonitoringPanel();
            this.counterSelectorView = new CounterSelectorTreeView3(this.getCounterNodeInternationalizer(), true);
            this.counterSelectorView.setAutoLoadNodes(true);
            this.dataDisplayView = new MultiGraphDataDisplayView();
            this.holeValue = this.dataDisplayView.getGraph().getHoleValue();
            this.pmPanel.getSplitPaneCountersGraph().setLeftComponent(this.counterSelectorView.getUI());
            this.pmPanel.getSplitPaneCountersGraph().setRightComponent(this.dataDisplayView.getUI());
            this.counterProvider = this.createCounterProvider();
            this.counterSelectorView.addEntity("" + this.equipment.getId(), this.counterProvider, "PMMonitoring");
            this.counterSelectorView.addPMCounterSelectorListener(this);
            AvPMCounterNode rootNode = this.counterSelectorView.getRoot("" + this.equipment.getId());
            AvPMCounterNodeUtil.setNodesDisplayModeByCounterType((AvPMCounterNode)rootNode);
            this.pmPanel.getBtnApply().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Integer spnValue = (Integer)PerformanceMonitoringSectionView.this.pmPanel.getSpnPolInterval().getValue();
                    if (spnValue > 3600) {
                        spnValue = 3600;
                        PerformanceMonitoringSectionView.this.pmPanel.getSpnPolInterval().setValue(spnValue);
                    }
                    PerformanceMonitoringSectionView.this.setPollingInterval(spnValue * 1000);
                }
            });
            this.refreshThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    logger.debug((Object)"PM collection thread - STARTED");
                    while (!PerformanceMonitoringSectionView.this.shouldStop) {
                        try {
                            long time = System.currentTimeMillis();
                            logger.debug((Object)("PM collection thread - woke " + (time - PerformanceMonitoringSectionView.this.lastRefreshTime) + " millis"));
                            if (time - PerformanceMonitoringSectionView.this.lastRefreshTime < (long)(PerformanceMonitoringSectionView.this.pollingInterval - 10)) {
                                Thread.sleep((long)PerformanceMonitoringSectionView.this.pollingInterval.intValue() - (time - PerformanceMonitoringSectionView.this.lastRefreshTime));
                            }
                            PerformanceMonitoringSectionView.this.lastRefreshTime = System.currentTimeMillis();
                            boolean hasSelectedCounters = PerformanceMonitoringSectionView.this.hasSelectedCounters();
                            if (!hasSelectedCounters) continue;
                            PerformanceMonitoringSectionView.this.refresh(true);
                            Object object = PerformanceMonitoringSectionView.this.refreshThreadLock;
                            synchronized (object) {
                                PerformanceMonitoringSectionView.this.refreshThreadLock.wait();
                            }
                        }
                        catch (InterruptedException t) {
                            logger.debug((Object)t.getMessage());
                        }
                        catch (Throwable t) {
                            logger.error((Object)t, t);
                        }
                    }
                    logger.debug((Object)"PM collection thread - STOPPED");
                }
            });
            this.refreshThread.start();
            this.pmPanel.getBtnReset().setEnabled(this.isButtonResetActive());
            this.pmPanel.getBtnReset().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (FrameUtil.showConfirmation(PerformanceMonitoringSectionView.this.pmPanel, i18n.translateString("AreYouSure"))) {
                        PerformanceMonitoringSectionView.this.resetCounters();
                    }
                }
            });
            this.pmPanel.getBtnStop().setVisible(this.isButtonStopVisible());
            if (this.isButtonStopVisible()) {
                this.pmPanel.getBtnStop().addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PerformanceMonitoringSectionView.this.btnStopActionPerformed();
                    }
                });
                this.pmPanel.getBtnStop().setEnabled(rootNode.hasSelectedChildren());
            }
        }
        return this.pmPanel;
    }

    protected PerformanceMonitoringViewCounterProvider createCounterProvider() {
        return new ManagedObjectRequestCounterProvider(this.equipment, this.getManagedObjectRequests());
    }

    protected abstract void resetCounters();

    protected abstract boolean isButtonResetActive();

    protected boolean isButtonStopVisible() {
        return false;
    }

    protected void btnStopActionPerformed() {
        AvPMCounterNode rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.setChildrenSelected(false);
        }
    }

    @Override
    public void apply(List<InvalidValue> invalidValues) {
    }

    protected void distributeManagedObjects(List<Object> managedObjects) {
        AvMultiCounterGraphData graphData = this.dataDisplayView.getGraph().getGraphData();
        for (Object data : managedObjects) {
            int i;
            Object[] dataToSet = this.counterProvider.getDataAsArray(data, "PMMonitoring");
            String[] counterIDs = (String[])dataToSet[0];
            Number[] gValues = (Number[])dataToSet[1];
            double[] values = new double[gValues.length];
            Long timeStamp = (Long)dataToSet[2];
            if (this.hiddenCounters.size() > 0) {
                for (i = 0; i < counterIDs.length; ++i) {
                    if (!this.hiddenCounters.contains(counterIDs[i])) continue;
                    gValues[i] = this.holeValue;
                }
            }
            this.dataDisplayView.addValues(counterIDs, gValues, timeStamp);
            for (i = 0; i < counterIDs.length; ++i) {
                int idx = graphData.getSeriesIndex(counterIDs[i]);
                if (idx == -1) {
                    values[i] = 0.0;
                } else {
                    values[i] = (Double)graphData.getLastValueUntrimmed(idx)[1];
                    if (values[i] == this.holeValue) {
                        values[i] = 0.0;
                    }
                }
                logger.debug((Object)("values[" + i + "]= " + values[i]));
            }
            this.counterSelectorView.setCounterValues(counterIDs, values, new boolean[values.length]);
            this.counterSelectorView.getUI().repaint();
        }
    }

    @Override
    public void refresh(boolean forceRefresh) {
        if (this.hasSelectedCounters()) {
            this.longActionCallback.onStarting("Refreshing ...");
            this.managedObjectsAccessSupport.requestManagedObjects(this.collectManagedObjectClasses(), forceRefresh);
            ((AbstractTableModel)((CounterSelectorTreePanel3)this.counterSelectorView.getUI()).getTreeTableCounters().getModel()).fireTableDataChanged();
        } else if (forceRefresh) {
            this.insertHoleValue();
        }
    }

    protected CounterNodeInternationalizer getCounterNodeInternationalizer() {
        return new CounterNodeInternationalizer(){

            public void translateNode(AvPMCounterNode node) {
            }
        };
    }

    protected List<? extends UnifiedMORequest> collectManagedObjectClasses() {
        return this.getManagedObjectRequests();
    }

    private List<ManagedObject> collectChanges(List<InvalidValue> invalidValues) {
        return new ArrayList<ManagedObject>();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public void cleanup() {
        this.shouldStop = true;
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(long equipmentId, String networkResourceName, Class<?> moClass) {
        return this.createRequest(equipmentId, networkResourceName, moClass, null);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(long equipmentId, String networkResourceName, Class<?> moClass, String instanceQuery) {
        return new ConfigFormManagedObjectRequest(equipmentId, networkResourceName, moClass, instanceQuery);
    }

    @Override
    public void registerLongActionCallback(LongActionCallback longActionCallback) {
        this.longActionCallback = longActionCallback;
    }

    @Override
    public void unregisterLongActionCallback() {
        this.longActionCallback = nullLongActionCallback;
    }

    @Override
    public void registerActionCallback(ActionCommandCallback actionCommandCallback) {
        this.actionCommandCallback = actionCommandCallback;
    }

    @Override
    public void fireAction(String url) {
        this.actionCommandCallback.fireAction(url);
    }

    @Override
    public void registerCommandCallback(CommandCallback commandCallback) {
        this.commandCallback = commandCallback;
    }

    @Override
    public void fireCommand(NetworkElementCommand command) {
        this.longActionCallback.onStarting("Applying command " + command.getName() + " ...");
        this.managedObjectsAccessSupport.postCommand(command.getEquipmentId(), command);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object value) {
        this.attributes.put(attributeName, value);
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    @Override
    public Equipment getEquipment() {
        return this.equipment;
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(String networkResourceName, Class<?> moClass) {
        return this.createRequest(this.equipment.getId(), networkResourceName, moClass, null);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(Class<?> moClass) {
        return this.createRequest(this.equipment.getId(), null, moClass, null);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(Class<?> moClass, String instanceQuery) {
        return this.createRequest(this.equipment.getId(), null, moClass, instanceQuery);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(String networkResourceName, Class<?> moClass, String instanceQuery) {
        return this.createRequest(this.equipment.getId(), networkResourceName, moClass, instanceQuery);
    }

    @Override
    public boolean canApply() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRefreshThread() {
        Object object = this.refreshThreadLock;
        synchronized (object) {
            this.refreshThreadLock.notify();
        }
    }

    protected abstract List<? extends UnifiedMORequest> getManagedObjectRequests();

    public synchronized void counterChanged(IAvGPMCounterDefinition pCounterDef) {
        logger.debug((Object)("counterChanged: " + pCounterDef));
        String counterID = pCounterDef.getCounterID();
        if (this.selectedCounterIDs.contains(counterID)) {
            this.dataDisplayView.updateCounter(pCounterDef);
        }
    }

    public synchronized void counterDeselected(IAvGPMCounterDefinition pCounterDef) {
        String entityID = pCounterDef.getEntityID();
        String counterID = pCounterDef.getCounterID();
        String counterName = pCounterDef.getName();
        this.dataDisplayView.setCounterVisible(counterID, false);
        this.hiddenCounters.add(counterID);
        this.updateButtonStopStatus();
        if (!this.hasSelectedCounters()) {
            this.insertHoleValue();
        }
    }

    private void updateButtonStopStatus() {
        if (this.isButtonStopVisible()) {
            this.pmPanel.getBtnStop().setEnabled(this.hasSelectedCounters());
        }
    }

    public synchronized void counterSelected(IAvGPMCounterDefinition pCounterDef) {
        String entityID = pCounterDef.getEntityID();
        String counterID = pCounterDef.getCounterID();
        String counterName = pCounterDef.getName();
        logger.debug((Object)("counterSelected: " + pCounterDef));
        if (!this.hiddenCounters.remove(counterID)) {
            this.selectedCounterIDs.add(counterID);
            Vector<IAvGPMCounterDefinition> deviceCounters = this.selectedCounters.get(entityID);
            if (deviceCounters == null) {
                deviceCounters = new Vector<IAvGPMCounterDefinition>();
                this.selectedCounters.put(entityID, deviceCounters);
            }
            if (!deviceCounters.contains(counterName)) {
                deviceCounters.add(pCounterDef);
                this.dataDisplayView.addCounter(pCounterDef);
            }
        } else {
            this.dataDisplayView.setCounterVisible(counterID, true);
        }
        this.counterChanged(pCounterDef);
        this.updateButtonStopStatus();
    }

    private boolean hasSelectedCounters() {
        AvPMCounterNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return false;
        }
        return rootNode.hasSelectedChildren();
    }

    protected AvPMCounterNode getRootNode() {
        if (this.equipment == null) {
            return null;
        }
        return this.counterSelectorView.getRoot(String.valueOf(this.equipment.getId()));
    }

    private void insertHoleValue() {
        if (this.selectedCounterIDs != null && this.selectedCounterIDs.size() > 0) {
            String[] counterIDs = this.selectedCounterIDs.toArray(new String[0]);
            this.dataDisplayView.addValues(counterIDs, new Number[counterIDs.length], System.currentTimeMillis());
            this.counterSelectorView.setCounterValues(counterIDs, new double[counterIDs.length], new boolean[counterIDs.length]);
        }
    }

    @Override
    public void setParentComponent(JComponent parentComponent) {
    }

    protected Integer getPollingInterval() {
        return this.pollingInterval;
    }

    protected void setPollingInterval(Integer pollingInterval) {
        if (pollingInterval != null && !pollingInterval.equals(this.pollingInterval)) {
            this.pollingInterval = pollingInterval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MOAccessCallback
    implements ManagedObjectsAccessSupportCallback {
        private final Logger logger = Logger.getLogger(MOAccessCallback.class);

        private MOAccessCallback() {
        }

        @Override
        public void handleRequestManagedObjectsCompleted(List<Object> managedObjects) {
            try {
                PerformanceMonitoringSectionView.this.distributeManagedObjects(managedObjects);
                PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Done.");
                PerformanceMonitoringSectionView.this.mosValid = true;
            }
            catch (Exception e) {
                this.logger.error((Object)"Error.", (Throwable)e);
                PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Error." + ExceptionUtil.getMessage(e));
            }
            PerformanceMonitoringSectionView.this.notifyRefreshThread();
        }

        @Override
        public void handleRequestManagedObjectsError(Throwable x) {
            this.handleThrowable(x);
            PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage(x));
            PerformanceMonitoringSectionView.this.notifyRefreshThread();
        }

        @Override
        public void handlePostManagedObjectsCompleted() {
            this.logger.debug((Object)"postManagedObjects() completed successfully.");
            PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Done.");
            PerformanceMonitoringSectionView.this.refresh(true);
        }

        @Override
        public void handlePostManagedObjectsError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            this.handleThrowable(x);
            PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage(x));
        }

        @Override
        public void handlePostCommandCompleted() {
            PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Done.");
            PerformanceMonitoringSectionView.this.refresh(true);
        }

        @Override
        public void handlePostCommandError(Throwable x) {
            this.logger.error((Object)"Error.", x);
            PerformanceMonitoringSectionView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage(x));
        }

        private void handleThrowable(Throwable x) {
            if (x instanceof EntityNotFoundException) {
                PerformanceMonitoringSectionView.this.mosValid = false;
            }
            if (x instanceof EquipmentCommunicationException) {
                PerformanceMonitoringSectionView.this.mosValid = false;
            }
            if (x instanceof EquipmentAgentException) {
                // empty if block
            }
        }
    }
}

