/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration.pm;

import com.bwanms.gui.configuration.pm.PerformanceMonitoringViewCounterProvider;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.model.Equipment;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectRequestCounterProvider
implements PerformanceMonitoringViewCounterProvider {
    private static final Logger log = Logger.getLogger(ManagedObjectRequestCounterProvider.class);
    protected final String entityId;
    private final String entityLabel;
    private Map counterData = new LinkedHashMap();

    public ManagedObjectRequestCounterProvider(Equipment eq, List<? extends UnifiedMORequest> requests) {
        this.entityId = "" + eq.getId();
        this.entityLabel = eq.getName();
        for (UnifiedMORequest unifiedMORequest : requests) {
            Class<?> moClazz = unifiedMORequest.getMoClass();
            String className = moClazz.getName();
            Vector<String[]> leafs = new Vector<String[]>();
            for (Method getter : BeanUtils.getPropertyGetters(moClazz)) {
                String propertyName = BeanUtils.getPropertyNameFromGetter(getter);
                if (!Number.class.isAssignableFrom(getter.getReturnType())) continue;
                SNMPParameter snmpParam = getter.getAnnotation(SNMPParameter.class);
                String type = "-1";
                if (snmpParam.type() == 65) {
                    type = "1";
                } else {
                    if (snmpParam.type() != 66) continue;
                    type = "2";
                }
                leafs.add(new String[]{propertyName, propertyName, type});
            }
            Hashtable<String, Vector<String[]>> category = new Hashtable<String, Vector<String[]>>();
            category.put("{leafs}", leafs);
            this.counterData.put(className, category);
        }
    }

    public Object getCounters(String pEntityOID, String pRootNode, int pDepth) {
        return this.counterData;
    }

    public String getProductLine(String pEntityOID) {
        return null;
    }

    public String getEntityLabel(String pEntityID) {
        return this.entityLabel;
    }

    @Override
    public Object[] getDataAsArray(Object data, String root) {
        ArrayList<String> counters = new ArrayList<String>();
        ArrayList<Double> values = new ArrayList<Double>();
        Long timeStamp = System.currentTimeMillis();
        for (Method getter : BeanUtils.getPropertyGetters(data.getClass())) {
            if (!Number.class.isAssignableFrom(getter.getReturnType())) continue;
            try {
                SNMPParameter snmpParam = getter.getAnnotation(SNMPParameter.class);
                if (snmpParam.type() != 65 && snmpParam.type() != 66) continue;
                counters.add(this.entityId + "/" + root + "/" + data.getClass().getName() + "/" + BeanUtils.getPropertyNameFromGetter(getter));
                double value = ((Number)getter.invoke(data, new Object[0])).doubleValue();
                values.add(value);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        String[] countersArray = new String[counters.size()];
        counters.toArray(countersArray);
        Number[] valuesArray = new Number[counters.size()];
        values.toArray(valuesArray);
        return new Object[]{countersArray, valuesArray, timeStamp};
    }
}

