/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.configuration.UnifiedFormsConfigSectionView;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.services.UnifiedMORequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnifiedMOsConfigForm<T extends JComponent>
extends ManagedObjectsConfigForm<T> {
    public UnifiedMOsConfigForm() {
        this.managedObjects = new ArrayList();
        this.binders = new ArrayList();
    }

    protected synchronized void fillUserInterface(Map<Class<?>, Object> moMap) {
        this.managedObjects.clear();
        for (UnifiedMORequest moReq : this.getManagedObjectRequests()) {
            this.managedObjects.add(moMap.get(moReq.getMoClass()));
        }
        this.binders.clear();
        this.createBinders(this.binders, this.managedObjects);
        this.initBoundedUI();
        this.fillBoundedUserInterface(this.binders, this.managedObjects);
        this.fillUI(this.managedObjects);
        this.cacheInitialGUIValues();
    }

    @Override
    protected List<Object> configureManagedObjects(List<InvalidValue> invalidValues) {
        ArrayList<Object> mos = new ArrayList<Object>();
        for (Object object : this.managedObjects) {
            if (!(object instanceof UnifiedMOSupport)) continue;
            mos.add((UnifiedMOSupport)object);
        }
        try {
            this.configureBoundedManagedObjects(invalidValues);
            this.configureMOs(mos, invalidValues);
        }
        catch (DuplicateEntryException e) {
            Internationalizer i18n = Internationalizer.getInternationalizer("com.bwanms.validator");
            invalidValues.add(new InvalidValue(i18n.translateString("duplicate.entry"), e.getEntryClass(), "rowKey", (Object)e.getRowKey(), null));
        }
        return mos;
    }

    @Override
    @Deprecated
    protected void fillUserInterface(List<Object> moList) {
        throw new UnsupportedOperationException("Not supported anymore");
    }

    @Override
    @Deprecated
    protected void configureMOs(List<Object> managedObjects) {
        throw new UnsupportedOperationException("Not supported anymore");
    }

    @Override
    @Deprecated
    public final String warnApply() {
        throw new UnsupportedOperationException("Replaced by method confirmBeforeApply");
    }

    public boolean confirmBeforeApply() {
        return true;
    }

    protected void createBinders(List<Binder> binders, Map<Class<?>, Object> moMap) {
    }

    private void fillBoundedUI() {
        if (this.binders != null) {
            for (Binder binder : this.binders) {
                binder.fillUI();
            }
        }
    }

    protected void fillUI(Map<Class<?>, Object> moMap) {
    }

    protected void configureMOs(Map<Class<?>, Object> moMap, List<InvalidValue> invalidValues) {
    }

    private void configureBoundedMOs(List<InvalidValue> invalidValues) {
        if (this.binders != null) {
            for (Binder binder : this.binders) {
                binder.configureBean(invalidValues);
            }
        }
    }

    protected final long getApplyId() {
        ConfigSectionView configSectionView = this.getConfigSectionView();
        if (configSectionView instanceof UnifiedFormsConfigSectionView) {
            return ((UnifiedFormsConfigSectionView)configSectionView).getApplyId();
        }
        return -1L;
    }

    protected final void putPopupMessage(String message, JDialog messageBox) {
        ConfigSectionView configSectionView = this.getConfigSectionView();
        if (configSectionView instanceof UnifiedFormsConfigSectionView) {
            ((UnifiedFormsConfigSectionView)configSectionView).putPopupMessage(message, messageBox);
        }
    }

    protected final void putPopupMessage(Map.Entry<String, JDialog> messageBoxEntry) {
        this.putPopupMessage(messageBoxEntry.getKey(), messageBoxEntry.getValue());
    }

    protected final boolean containsPopupMessage(String message) {
        ConfigSectionView configSectionView = this.getConfigSectionView();
        if (configSectionView instanceof UnifiedFormsConfigSectionView) {
            return ((UnifiedFormsConfigSectionView)configSectionView).containsPopupMessage(message);
        }
        return false;
    }

    protected final <F extends ManagedObjectsConfigForm> F getConfigForm(Class<F> configFormClass) {
        return ((UnifiedFormsConfigSectionView)this.getConfigSectionView()).getConfigForm(configFormClass);
    }
}

