/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.configuration.ManagedObjectsAccessSupport;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkDomainObject;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.ui.platform.UIEventThread;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedMOsAccessSupport
extends ManagedObjectsAccessSupport {
    private static final Logger logger = Logger.getLogger(UnifiedMOsAccessSupport.class);

    public UnifiedMOsAccessSupport(ManagedObjectsAccessSupportCallback callback) {
        super(callback);
    }

    @Override
    public void requestManagedObjects(final List<? extends UnifiedMORequest> moRequests, final boolean forceRefresh) {
        new UIBackgroundJob(){

            public void run() {
                try {
                    final ArrayList<Object> results = new ArrayList<Object>();
                    for (UnifiedMORequest moRequest : moRequests) {
                        if (ManagedObject.class.isAssignableFrom(moRequest.getMoClass())) {
                            UnifiedMOSupport moSupport = new UnifiedMOSupport(moRequest.getMoClass(), ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moRequest.getMoClass(), moRequest.getInstanceQuery() == null ? "*" : moRequest.getInstanceQuery(), forceRefresh));
                            moSupport.setNRConfigName(moRequest.getNetworkResource());
                            results.add(moSupport);
                            continue;
                        }
                        if (!NetworkDomainObject.class.isAssignableFrom(moRequest.getMoClass())) continue;
                        results.add(ServiceRegistry.getConfigurationService().retrieveData(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moRequest.getMoClass(), moRequest.getInstanceQuery() == null ? "*" : moRequest.getInstanceQuery()));
                    }
                    UIEventThread.asyncExec(new Runnable(){

                        public void run() {
                            try {
                                logger.debug((Object)("MO list size: " + results.size()));
                                UnifiedMOsAccessSupport.this.callback.handleRequestManagedObjectsCompleted(results);
                                logger.debug((Object)"Done");
                            }
                            catch (Throwable e) {
                                logger.error((Object)"run()", e);
                            }
                        }
                    });
                }
                catch (UndeclaredThrowableException x) {
                    UnifiedMOsAccessSupport.this.callback.handleRequestManagedObjectsError(x);
                }
                catch (Throwable x) {
                    UnifiedMOsAccessSupport.this.callback.handleRequestManagedObjectsError(x);
                }
            }
        }.schedule();
    }
}

