/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.configuration.UnifiedMOsAccessSupport;
import com.bwanms.gui.configuration.UnifiedMOsConfigForm;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.MessageBox;
import com.bwanms.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedFormsConfigSectionView
extends FormsConfigSectionView {
    private int applyNo;
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(FormsConfigSectionView.class);
    private final Map<String, JDialog> popupMessages;

    public UnifiedFormsConfigSectionView() {
        this.attributes = new HashMap();
        this.configForms = new ArrayList();
        this.formManagedObjects = new ArrayList();
        this.managedObjectsAccessSupport = new UnifiedMOsAccessSupport(new FormsConfigSectionView.MOAccessCallback());
        this.popupMessages = new LinkedHashMap<String, JDialog>();
    }

    @Override
    public void apply(List<InvalidValue> invalidValues) {
        ++this.applyNo;
        this.popupMessages.clear();
        List<Object> mos = this.collectChanges(invalidValues);
        this.validateForms(invalidValues);
        if (invalidValues.size() == 0) {
            for (ManagedObjectsConfigForm form : this.configForms) {
                if (((UnifiedMOsConfigForm)form).confirmBeforeApply()) continue;
                return;
            }
            if (SystemPropertyUtil.getBoolean("com.bwanms.serviceAffectingWarning", "true", false) && !MessageBox.WarnConfirm.showResult(this.getUI().getTopLevelAncestor(), i18n.translateString("ServiceAffectingWarning"))) {
                return;
            }
            for (String popupMessage : this.popupMessages.keySet()) {
                this.popupMessages.get(popupMessage).setVisible(true);
            }
            this.longActionCallback.onStarting("Applying ...");
            this.managedObjectsAccessSupport.postConfigurationUpdate(this.equipment, mos);
        } else {
            for (ManagedObjectsConfigForm form : this.configForms) {
                form.resetMOs();
            }
        }
    }

    @Override
    protected void distributeManagedObjects(List<Object> managedObjects) {
        HashMap moMap = new HashMap();
        for (Object obj : managedObjects) {
            if (!(obj instanceof UnifiedMOSupport)) continue;
            UnifiedMOSupport moSupport = (UnifiedMOSupport)obj;
            moSupport.getChangeStrategy().acknowledge();
            moMap.put(moSupport.getParameterClass(), moSupport);
        }
        for (ManagedObjectsConfigForm configForm : this.configForms) {
            if (!(configForm instanceof UnifiedMOsConfigForm)) continue;
            ((UnifiedMOsConfigForm)configForm).fillUserInterface(moMap);
        }
    }

    @Override
    protected List<? extends UnifiedMORequest> collectManagedObjectsRequests() {
        ArrayList moRequests = new ArrayList();
        LinkedHashMap moReqMap = new LinkedHashMap();
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            for (UnifiedMORequest moReq : moConfigForm.getCachedManagedObjectRequests()) {
                moReqMap.put(moReq.getMoClass(), moReq);
            }
        }
        moRequests.addAll(moReqMap.values());
        return moRequests;
    }

    @Override
    protected List<Object> collectChanges(List<InvalidValue> invalidValues) {
        LinkedHashSet<Object> retSet = new LinkedHashSet<Object>();
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            List<Object> configureMOs = moConfigForm.configureManagedObjects(invalidValues);
            if (configureMOs == null) continue;
            retSet.addAll(configureMOs);
        }
        ArrayList<Object> ret2 = new ArrayList<Object>(retSet.size());
        ret2.addAll(retSet);
        return ret2;
    }

    public final <F extends ManagedObjectsConfigForm> F getConfigForm(Class<F> configFormClass) {
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            if (!moConfigForm.getClass().equals(configFormClass)) continue;
            return (F)moConfigForm;
        }
        return null;
    }

    protected long getApplyId() {
        return ((long)this.hashCode() << 32) + (long)this.applyNo;
    }

    void putPopupMessage(String message, JDialog messageBox) {
        if (message == null || messageBox == null) {
            throw new NullPointerException();
        }
        this.popupMessages.put(message, messageBox);
    }

    boolean containsPopupMessage(String message) {
        return this.popupMessages.containsKey(message);
    }
}

