/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.UIValidator;
import com.bwanms.gui.configuration.ActionCommandCallback;
import com.bwanms.gui.configuration.CommandCallback;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigFormContext;
import com.bwanms.gui.util.SortedTableModel;
import com.bwanms.mo.ManagedObject;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedObjectsConfigForm<UIComponent extends JComponent>
implements CommandCallback {
    private String title = "";
    private UIComponent component;
    private List<? extends UnifiedMORequest> managedObjectRequests;
    protected List<Object> managedObjects;
    protected ManagedObjectsConfigFormContext ctx;
    private ActionCommandCallback actionCommandCallback;
    private CommandCallback commandCallback;
    protected ArrayList<Binder> binders;
    private ConfigSectionView configSectionView;
    private HashMap<Component, Object> initialGUIValues = new HashMap();
    private boolean areGUIValuesCached = false;

    public final void setContext(ManagedObjectsConfigFormContext ctx) {
        this.ctx = ctx;
    }

    public final ManagedObjectsConfigFormContext getContext() {
        return this.ctx;
    }

    public String getTitle() {
        return this.title;
    }

    protected void resetMOs() {
        for (Object object : this.managedObjects) {
            if (!(object instanceof ManagedObject)) continue;
            ManagedObject mo = (ManagedObject)object;
            mo.getChangeStrategy().reset();
        }
    }

    protected synchronized void fillUserInterface(List<Object> moList) {
        this.areGUIValuesCached = false;
        this.managedObjects = moList;
        this.binders = new ArrayList();
        this.createBinders(this.binders, this.managedObjects);
        this.initBoundedUI();
        this.fillBoundedUserInterface(this.binders, this.managedObjects);
        this.fillUI(this.managedObjects);
        this.cacheInitialGUIValues();
    }

    protected List<Object> configureManagedObjects(List<InvalidValue> invalidValues) {
        ArrayList<Object> mos = new ArrayList<Object>();
        for (Object object : this.managedObjects) {
            if (!(object instanceof ManagedObject)) continue;
            mos.add((ManagedObject)object);
        }
        this.configureMOs(mos);
        this.configureMOs(mos, invalidValues);
        this.configureBoundedManagedObjects(invalidValues);
        return mos;
    }

    protected void fillBoundedUserInterface(ArrayList<Binder> binders, List<Object> managedObjects) {
        for (Binder binder : binders) {
            binder.fillUI();
        }
    }

    protected void configureBoundedManagedObjects(List<InvalidValue> invalidValues) {
        if (this.binders != null) {
            for (Binder binder : this.binders) {
                UIValidator.validate(invalidValues, binder);
            }
        }
    }

    public void fireAction(String url) {
        this.actionCommandCallback.fireAction(url);
    }

    public void setActionCommandCallback(ActionCommandCallback actionCommandCallback) {
        this.actionCommandCallback = actionCommandCallback;
    }

    protected ActionCommandCallback getActionCommandCallback() {
        return this.actionCommandCallback;
    }

    @Override
    public void fireCommand(NetworkElementCommand command) {
        this.commandCallback.fireCommand(command);
    }

    public void registerCommandCallback(CommandCallback commandCallback) {
        this.commandCallback = commandCallback;
    }

    public List<? extends UnifiedMORequest> getCachedManagedObjectRequests() {
        if (this.managedObjectRequests == null) {
            this.managedObjectRequests = this.getManagedObjectRequests();
        }
        return this.managedObjectRequests;
    }

    protected void initBoundedUI() {
        for (Binder binder : this.binders) {
            binder.initUI();
        }
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
    }

    @Deprecated
    protected void validateUI(List<InvalidValue> invalidValues) {
    }

    protected void fillUI(List<Object> managedObjects) {
    }

    @Deprecated
    protected void configureMOs(List<Object> managedObjects) {
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
    }

    protected abstract List<? extends UnifiedMORequest> getManagedObjectRequests();

    protected abstract UIComponent initUIComponent();

    public UIComponent getUI() {
        if (this.component == null) {
            this.component = this.initUIComponent();
        }
        return this.component;
    }

    protected void cacheInitialGUIValues() {
        this.areGUIValuesCached = false;
        this.initialGUIValues.clear();
        this.cacheInitialGUIValues((Component)this.component);
        this.areGUIValuesCached = true;
    }

    private void cacheInitialGUIValues(Component component) {
        if (this.canApply()) {
            if (component instanceof JTextComponent) {
                if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                    this.initialGUIValues.put(component, ((JTextComponent)component).getText());
                }
            } else if (component instanceof JComboBox) {
                if (component.isEnabled()) {
                    this.initialGUIValues.put(component, ((JComboBox)component).getSelectedItem());
                }
            } else if (component instanceof JSpinner) {
                if (component.isEnabled()) {
                    this.initialGUIValues.put(component, ((JSpinner)component).getValue());
                }
            } else if (component instanceof JCheckBox) {
                if (component.isEnabled()) {
                    this.initialGUIValues.put(component, ((JCheckBox)component).isSelected());
                }
            } else if (component instanceof JRadioButton) {
                if (component.isEnabled()) {
                    this.initialGUIValues.put(component, ((JRadioButton)component).isSelected());
                }
            } else if (component instanceof JList) {
                if (component.isEnabled()) {
                    ArrayList items = new ArrayList();
                    ListModel listModel = ((JList)component).getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        items.add(listModel.getElementAt(i));
                    }
                    this.initialGUIValues.put(component, items.toArray());
                }
            } else if (component instanceof JTable) {
                if (component.isEnabled()) {
                    this.initialGUIValues.put(component, ManagedObjectsConfigForm.getRowsData((JTable)component));
                }
            } else if (component instanceof JComponent && component.isEnabled()) {
                for (Component c : ((JComponent)component).getComponents()) {
                    this.cacheInitialGUIValues(c);
                }
            }
        }
    }

    public boolean hasInitialGUIValue(Component component) {
        if (!this.areGUIValuesCached || !this.canApply()) {
            return true;
        }
        if (component instanceof JTextComponent) {
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                return ((JTextComponent)component).getText().equals(this.initialGUIValues.get(component));
            }
        } else if (component instanceof JComboBox) {
            if (component.isEnabled()) {
                Object selectedItem = ((JComboBox)component).getSelectedItem();
                if (selectedItem == null) {
                    return this.initialGUIValues.get(component) == null;
                }
                return selectedItem.equals(this.initialGUIValues.get(component));
            }
        } else if (component instanceof JSpinner) {
            if (component.isEnabled()) {
                Object selectedValue = ((JSpinner)component).getValue();
                if (selectedValue == null) {
                    return this.initialGUIValues.get(component) == null;
                }
                return selectedValue.equals(this.initialGUIValues.get(component));
            }
        } else if (component instanceof JCheckBox) {
            if (component.isEnabled()) {
                return Boolean.valueOf(((JCheckBox)component).isSelected()).equals(this.initialGUIValues.get(component));
            }
        } else if (component instanceof JRadioButton) {
            if (component.isEnabled()) {
                return Boolean.valueOf(((JRadioButton)component).isSelected()).equals(this.initialGUIValues.get(component));
            }
        } else if (component instanceof JList) {
            if (component.isEnabled()) {
                ArrayList items = new ArrayList();
                ListModel listModel = ((JList)component).getModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    items.add(listModel.getElementAt(i));
                }
                Object initialValues = this.initialGUIValues.get(component);
                return initialValues instanceof Object[] && Arrays.equals(items.toArray(), (Object[])initialValues);
            }
        } else if (component instanceof JTable) {
            if (component.isEnabled()) {
                FormUtil.stopTableEditing((JTable)component);
                JTable table = (JTable)component;
                if (table.getModel() instanceof SimpleRowTableModel) {
                    int tableRowsState = ManagedObjectsConfigForm.getTableRowsState((SimpleRowTableModel)table.getModel());
                    if (tableRowsState == 2 || tableRowsState == 1) {
                        return false;
                    }
                    if (tableRowsState == 0) {
                        return true;
                    }
                }
                Object[] tableData = ManagedObjectsConfigForm.getRowsData((JTable)component);
                Object[] initialValues = (Object[])this.initialGUIValues.get(component);
                return Arrays.deepEquals(initialValues, tableData);
            }
        } else if (component instanceof JComponent && component.isEnabled()) {
            for (Component c : ((JComponent)component).getComponents()) {
                if (this.hasInitialGUIValue(c)) continue;
                return false;
            }
        }
        return true;
    }

    private static int getTableRowsState(SimpleRowTableModel tableModel) {
        int ret = 0;
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            int rowState = tableModel.getRowState(row);
            if (rowState == 2 || rowState == 1) {
                return rowState;
            }
            if (ret != 0 || rowState != 3 && rowState != 5) continue;
            ret = rowState;
        }
        return ret;
    }

    private static Object[] getRowsData(JTable jTable) {
        if (jTable.getModel() instanceof SimpleRowTableModel) {
            SimpleRowTableModel tableModel = (SimpleRowTableModel)jTable.getModel();
            Object[] rows = new Object[tableModel.getRowCount()];
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                    if (!tableModel.isCellEditable(i, j)) continue;
                    row.add(tableModel.getValueAt(i, j));
                }
                int modelRowIndex = tableModel.modelIndex(i);
                if (modelRowIndex <= -1 || modelRowIndex < rows.length) {
                    // empty if block
                }
                rows[modelRowIndex] = row.toArray();
            }
            return rows;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        TableModel tableModel = jTable.getModel() instanceof SortedTableModel ? ((SortedTableModel)jTable.getModel()).getTableModel() : jTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                if (!tableModel.isCellEditable(i, j)) continue;
                row.add(tableModel.getValueAt(i, j));
            }
            rows.add(row.toArray());
        }
        return rows.toArray();
    }

    public boolean canApply() {
        return true;
    }

    public String warnApply() {
        return null;
    }

    protected void handleDisconnectedEquipment() {
    }

    public abstract String getHelpTopic();

    public boolean forceRefresh() {
        return false;
    }

    public ConfigSectionView getConfigSectionView() {
        return this.configSectionView;
    }

    public void setConfigSectionView(ConfigSectionView configSectionView) {
        this.configSectionView = configSectionView;
    }
}

