/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkDomainObject;
import com.bwanms.model.Equipment;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.ui.platform.UIEventThread;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectsAccessSupport {
    private static final Logger logger = Logger.getLogger(ManagedObjectsAccessSupport.class);
    protected ManagedObjectsAccessSupportCallback callback;

    public ManagedObjectsAccessSupport(ManagedObjectsAccessSupportCallback callback) {
        this.callback = callback;
    }

    public void requestManagedObjects(final List<? extends UnifiedMORequest> moRequests, final boolean forceRefresh) {
        new UIBackgroundJob(){

            public void run() {
                try {
                    final ArrayList<Object> results = new ArrayList<Object>();
                    for (ConfigFormManagedObjectRequest moRequest : moRequests) {
                        if (ManagedObject.class.isAssignableFrom(moRequest.getMoClass())) {
                            if (moRequest.getInstanceQuery() != null) {
                                results.addAll(ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moRequest.getMoClass(), moRequest.getInstanceQuery(), forceRefresh));
                                continue;
                            }
                            ArrayList<Class<? extends ManagedObject>> moClasses = new ArrayList<Class<? extends ManagedObject>>();
                            moClasses.add(moRequest.getMoClass());
                            results.addAll(ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moClasses, forceRefresh));
                            continue;
                        }
                        if (NetworkDomainObject.class.isAssignableFrom(moRequest.getMoClass())) {
                            results.addAll(ServiceRegistry.getConfigurationService().retrieveData(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moRequest.getMoClass(), moRequest.getInstanceQuery() == null ? "*" : moRequest.getInstanceQuery()));
                            continue;
                        }
                        ArrayList<Class> dataClasses = new ArrayList<Class>();
                        dataClasses.add(moRequest.getMoClass());
                        results.addAll(ServiceRegistry.getConfigurationService().retrieveData(moRequest.getEquipmentId(), dataClasses));
                    }
                    UIEventThread.asyncExec(new Runnable(){

                        public void run() {
                            try {
                                logger.debug((Object)("MO list size: " + results.size()));
                                ManagedObjectsAccessSupport.this.callback.handleRequestManagedObjectsCompleted(results);
                                logger.debug((Object)"Done");
                            }
                            catch (Throwable e) {
                                logger.error((Object)"run()", e);
                            }
                        }
                    });
                }
                catch (UndeclaredThrowableException x) {
                    ManagedObjectsAccessSupport.this.callback.handleRequestManagedObjectsError(x);
                }
                catch (Throwable x) {
                    ManagedObjectsAccessSupport.this.callback.handleRequestManagedObjectsError(x);
                }
            }
        }.schedule();
    }

    public void postConfigurationUpdate(final Equipment equipment, final List<ManagedObject> configUpdate) {
        new UIBackgroundJob(){

            public void run() {
                try {
                    ServiceRegistry.getConfigurationService().updateCurrentConfiguration(equipment.getId(), configUpdate);
                    ManagedObjectsAccessSupport.this.callback.handlePostManagedObjectsCompleted();
                }
                catch (ServiceException x) {
                    for (ManagedObject mo : configUpdate) {
                        mo.getChangeStrategy().reset();
                    }
                    ManagedObjectsAccessSupport.this.callback.handlePostManagedObjectsError(x);
                }
                catch (UndeclaredThrowableException e) {
                    ManagedObjectsAccessSupport.this.callback.handlePostCommandError(e.getCause());
                }
            }
        }.schedule();
    }

    public void postCommand(final long equipmentId, final NetworkElementCommand command) {
        new UIBackgroundJob(){

            public void run() {
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(command);
                    ServiceRegistry.getConfigurationService().sendData(equipmentId, list);
                    ManagedObjectsAccessSupport.this.callback.handlePostCommandCompleted();
                }
                catch (ServiceException x) {
                    ManagedObjectsAccessSupport.this.callback.handlePostCommandError(x);
                }
                catch (UndeclaredThrowableException e) {
                    ManagedObjectsAccessSupport.this.callback.handlePostCommandError(e.getCause());
                }
            }
        }.schedule();
    }
}

