/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ActionCommandCallback;
import com.bwanms.gui.configuration.CommandCallback;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.DefaultConfigSectionEditorPanel;
import com.bwanms.gui.configuration.EquipmentManagerNotFoundException;
import com.bwanms.gui.configuration.LongActionCallback;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupport;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.configuration.ManagedObjectsConfigFormContext;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.EquipmentAgentException;
import com.bwanms.services.EquipmentCommunicationException;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.MessageBox;
import com.bwanms.util.SystemPropertyUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsConfigSectionView
implements ConfigSectionView,
ManagedObjectsConfigFormContext,
ActionCommandCallback,
CommandCallback {
    private static final Logger logger = Logger.getLogger(FormsConfigSectionView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(FormsConfigSectionView.class);
    protected List<ManagedObjectsConfigForm> configForms;
    protected ManagedObjectsAccessSupport managedObjectsAccessSupport;
    protected HashMap<String, Object> attributes = new HashMap();
    protected List<FormManagedObjects> formManagedObjects;
    protected boolean mosValid = false;
    private JComponent parentComponent;
    private JComponent configFormContainer;
    private List<? extends UnifiedMORequest> moRequests;
    protected LongActionCallback longActionCallback;
    private String title;
    protected Equipment equipment;
    private ActionCommandCallback actionCommandCallback;
    private CommandCallback commandCallback;
    private boolean shouldStop = false;
    private static final LongActionCallback nullLongActionCallback = new LongActionCallback(){

        public void onStarting(String message) {
        }

        public void onFinished(String message) {
        }
    };

    public FormsConfigSectionView() {
        this.configForms = new ArrayList<ManagedObjectsConfigForm>();
        this.managedObjectsAccessSupport = new ManagedObjectsAccessSupport(new MOAccessCallback());
    }

    private static void makeDialogVisibleIfParentIsVisible(JDialog dialog, JComponent parentComponent) {
        Window dialogParentWindow = FormsConfigSectionView.getWindowForComponent(parentComponent);
        if (dialogParentWindow != null && dialogParentWindow.isVisible()) {
            dialog.setVisible(true);
        }
    }

    private static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return FormsConfigSectionView.getWindowForComponent(parentComponent.getParent());
    }

    @Override
    public JComponent getUI() {
        if (this.configFormContainer == null) {
            if (this.configForms.size() == 0) {
                this.configFormContainer = new JPanel();
            } else if (this.configForms.size() == 1) {
                this.configFormContainer = this.configForms.get(0).getUI();
            } else {
                this.configFormContainer = new DefaultConfigSectionEditorPanel();
                for (ManagedObjectsConfigForm configForm : this.configForms) {
                    ((DefaultConfigSectionEditorPanel)this.configFormContainer).addPanel(configForm.getTitle(), (JComponent)configForm.getUI());
                }
            }
        }
        return this.configFormContainer;
    }

    @Override
    public void setParentComponent(JComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.shouldStop = parentComponent == null;
    }

    @Override
    public void apply(List<InvalidValue> invalidValues) {
        List<Object> mos = this.collectChanges(invalidValues);
        this.validateForms(invalidValues);
        this.sort(invalidValues);
        if (invalidValues.size() == 0) {
            for (ManagedObjectsConfigForm form : this.configForms) {
                if (form.warnApply() == null || MessageBox.WarnConfirm.showResult(this.getUI(), form.warnApply())) continue;
                return;
            }
            if (SystemPropertyUtil.getBoolean("com.bwanms.serviceAffectingWarning", "true", false) && !MessageBox.WarnConfirm.showResult(this.getUI().getTopLevelAncestor(), i18n.translateString("ServiceAffectingWarning"))) {
                return;
            }
            this.longActionCallback.onStarting("Applying ...");
            this.managedObjectsAccessSupport.postConfigurationUpdate(this.equipment, mos);
        } else {
            for (ManagedObjectsConfigForm form : this.configForms) {
                form.resetMOs();
            }
        }
    }

    private void sort(List<InvalidValue> invalidValues) {
    }

    public void validateForms(List<InvalidValue> invalidValues) {
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            moConfigForm.validateUI(invalidValues);
        }
    }

    protected void distributeManagedObjects(List<Object> managedObjects) {
        for (Object mo : managedObjects) {
            if (!(mo instanceof ManagedObject)) continue;
            ((ManagedObject)mo).getChangeStrategy().acknowledge();
        }
        for (ManagedObjectsConfigForm configForm : this.configForms) {
            configForm.fillUserInterface(this.searchManagedObjects(configForm.getCachedManagedObjectRequests(), managedObjects));
        }
    }

    private List<Object> searchManagedObjects(List<ConfigFormManagedObjectRequest> requests, List<Object> managedObjects) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ConfigFormManagedObjectRequest request : requests) {
            for (Object object : managedObjects) {
                if (object instanceof ManagedObject) {
                    ManagedObject mo = (ManagedObject)object;
                    if (!request.getMoClass().isAssignableFrom(mo.getClass()) || !mo.getNRConfiguration().getName().equals(request.getNetworkResource())) continue;
                    result.add(mo);
                    continue;
                }
                if (!request.getMoClass().isAssignableFrom(object.getClass())) continue;
                result.add(object);
            }
        }
        return result;
    }

    @Override
    public void refresh(boolean forceRefresh) {
        this.longActionCallback.onStarting("Refreshing ...");
        boolean formsForceRefresh = false;
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            formsForceRefresh = formsForceRefresh || moConfigForm.forceRefresh();
        }
        this.managedObjectsAccessSupport.requestManagedObjects(this.collectManagedObjectsRequests(), forceRefresh || formsForceRefresh);
    }

    protected List<? extends UnifiedMORequest> collectManagedObjectsRequests() {
        if (this.moRequests == null) {
            this.moRequests = new ArrayList<UnifiedMORequest>();
            for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
                this.moRequests.addAll(moConfigForm.getCachedManagedObjectRequests());
            }
        }
        return this.moRequests;
    }

    protected List<Object> collectChanges(List<InvalidValue> invalidValues) {
        this.formManagedObjects = new ArrayList<FormManagedObjects>();
        ArrayList<Object> ret = new ArrayList<Object>();
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            List<Object> configureMOs = moConfigForm.configureManagedObjects(invalidValues);
            if (configureMOs == null) continue;
            this.formManagedObjects.add(new FormManagedObjects(ret.size(), moConfigForm, configureMOs));
            ret.addAll(configureMOs);
        }
        return ret;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getHelpTopic() {
        if (!this.configForms.isEmpty()) {
            return this.configForms.get(0).getHelpTopic();
        }
        return "";
    }

    public void addConfigForm(ManagedObjectsConfigForm configForm) {
        configForm.setContext(this);
        configForm.setActionCommandCallback(this);
        configForm.registerCommandCallback(this);
        configForm.setConfigSectionView(this);
        this.configForms.add(configForm);
    }

    @Override
    public boolean isChanged() {
        for (ManagedObjectsConfigForm moConfigForm : this.configForms) {
            if (moConfigForm.hasInitialGUIValue((Component)moConfigForm.getUI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        this.parentComponent = null;
        return true;
    }

    @Override
    public void cleanup() {
        this.shouldStop = true;
    }

    @Override
    public void registerLongActionCallback(LongActionCallback longActionCallback) {
        this.longActionCallback = longActionCallback;
    }

    @Override
    public void unregisterLongActionCallback() {
        this.longActionCallback = nullLongActionCallback;
    }

    @Override
    public void registerActionCallback(ActionCommandCallback actionCommandCallback) {
        this.actionCommandCallback = actionCommandCallback;
    }

    @Override
    public void fireAction(String url) {
        this.actionCommandCallback.fireAction(url);
    }

    @Override
    public void registerCommandCallback(CommandCallback commandCallback) {
        this.commandCallback = commandCallback;
    }

    @Override
    public void fireCommand(NetworkElementCommand command) {
        this.longActionCallback.onStarting("Applying command " + command.getName() + " ...");
        this.managedObjectsAccessSupport.postCommand(command.getEquipmentId(), command);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object value) {
        this.attributes.put(attributeName, value);
    }

    public Object removeAttribute(String attributeName) {
        return this.attributes.remove(attributeName);
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    @Override
    public Equipment getEquipment() {
        return this.equipment;
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(long equipmentId, String networkResourceName, Class<?> moClass, String instanceQuery) {
        return new ConfigFormManagedObjectRequest(equipmentId, networkResourceName, moClass, instanceQuery);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(String networkResourceName, Class<?> moClass, String instanceQuery) {
        return this.createRequest(this.equipment.getId(), networkResourceName, moClass, instanceQuery);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(Class<?> moClass, String instanceQuery) {
        return this.createRequest(null, moClass, instanceQuery);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(long equipmentId, String networkResourceName, Class<?> moClass) {
        return this.createRequest(equipmentId, networkResourceName, moClass, null);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(String networkResourceName, Class<?> moClass) {
        return this.createRequest(networkResourceName, moClass, null);
    }

    @Override
    public ConfigFormManagedObjectRequest createRequest(Class<?> moClass) {
        return this.createRequest(moClass, null);
    }

    @Override
    public boolean canApply() {
        for (ManagedObjectsConfigForm form : this.configForms) {
            if (!form.canApply()) continue;
            return true;
        }
        return false;
    }

    public boolean isShouldStop() {
        return this.shouldStop;
    }

    public void setMoRequestsNull() {
        this.moRequests = null;
    }

    protected JComponent getParentComponent() {
        return this.parentComponent;
    }

    protected void setManagedObjectsAccessSupport(ManagedObjectsAccessSupport managedObjectsAccessSupport) {
        this.managedObjectsAccessSupport = managedObjectsAccessSupport;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FormManagedObjects {
        private int index;
        private ManagedObjectsConfigForm moCofigForm;
        private List<Object> configureMOs;

        public FormManagedObjects(int index, ManagedObjectsConfigForm moConfigForm, List<Object> configureMOs) {
            this.index = index;
            this.moCofigForm = moConfigForm;
            this.configureMOs = configureMOs;
        }

        public List<Object> getConfigureMOs() {
            return this.configureMOs;
        }

        public ManagedObjectsConfigForm getMoCofigForm() {
            return this.moCofigForm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MOAccessCallback
    implements ManagedObjectsAccessSupportCallback {
        private final Logger logger = Logger.getLogger(MOAccessCallback.class);
        private JDialog eqDisconnectedAlertDialog;
        private JDialog deviceErrorAlertDialog;
        private JDialog tempDownErrorDialog;
        private JDialog agentErrorDialog;

        @Override
        public void handleRequestManagedObjectsCompleted(List<Object> managedObjects) {
            try {
                FormsConfigSectionView.this.distributeManagedObjects(managedObjects);
                FormsConfigSectionView.this.longActionCallback.onFinished("Done.");
                FormsConfigSectionView.this.mosValid = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.debug((Object)"Error.", (Throwable)e);
                FormsConfigSectionView.this.longActionCallback.onFinished("Error." + ExceptionUtil.getMessage(e));
            }
        }

        @Override
        public void handleRequestManagedObjectsError(Throwable x) {
            this.logger.debug((Object)"Error.", x);
            this.handleThrowable(x);
            FormsConfigSectionView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage(x));
        }

        @Override
        public void handlePostManagedObjectsCompleted() {
            FormsConfigSectionView.this.longActionCallback.onFinished("Done.");
            FormsConfigSectionView.this.refresh(false);
        }

        @Override
        public void handlePostManagedObjectsError(Throwable x) {
            this.logger.debug((Object)"Error.", x);
            this.handleThrowable(x);
            FormsConfigSectionView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage(x));
        }

        @Override
        public void handlePostCommandCompleted() {
            FormsConfigSectionView.this.longActionCallback.onFinished("Done.");
            FormsConfigSectionView.this.refresh(true);
        }

        @Override
        public void handlePostCommandError(Throwable x) {
            this.logger.debug((Object)"Error.", x);
            FormsConfigSectionView.this.longActionCallback.onFinished("Error. " + ExceptionUtil.getMessage(x));
        }

        protected void handleThrowable(Throwable x) {
            if (x instanceof EquipmentManagerNotFoundException) {
                if (FormsConfigSectionView.this.configForms.size() == 1) {
                    FormsConfigSectionView.this.configForms.get(0).handleDisconnectedEquipment();
                }
                if (this.eqDisconnectedAlertDialog == null) {
                    this.eqDisconnectedAlertDialog = MessageBox.Alert.create(FormsConfigSectionView.this.parentComponent, i18n.translateString("DisconnectedEquipment"));
                }
                FormsConfigSectionView.makeDialogVisibleIfParentIsVisible(this.eqDisconnectedAlertDialog, FormsConfigSectionView.this.parentComponent);
                FormsConfigSectionView.this.mosValid = false;
            }
            if (x instanceof EntityNotFoundException) {
                if (this.deviceErrorAlertDialog == null) {
                    this.deviceErrorAlertDialog = MessageBox.Alert.create(FormsConfigSectionView.this.parentComponent, i18n.translateString("DeviceError"));
                }
                FormsConfigSectionView.makeDialogVisibleIfParentIsVisible(this.deviceErrorAlertDialog, FormsConfigSectionView.this.parentComponent);
                FormsConfigSectionView.this.mosValid = false;
            }
            if (x instanceof EquipmentCommunicationException) {
                if (this.tempDownErrorDialog == null) {
                    this.tempDownErrorDialog = MessageBox.Error.create(FormsConfigSectionView.this.parentComponent, i18n.translateString("DeviceTempDown"));
                }
                FormsConfigSectionView.makeDialogVisibleIfParentIsVisible(this.tempDownErrorDialog, FormsConfigSectionView.this.parentComponent);
                FormsConfigSectionView.this.mosValid = false;
            }
            if (x instanceof EquipmentAgentException) {
                if (this.agentErrorDialog == null) {
                    this.agentErrorDialog = MessageBox.Error.create(FormsConfigSectionView.this.parentComponent, i18n.translateString("AgentException"));
                }
                FormsConfigSectionView.makeDialogVisibleIfParentIsVisible(this.agentErrorDialog, FormsConfigSectionView.this.parentComponent);
            }
        }
    }
}

