/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.configuration.ItemFormatter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedItemsTree
extends JTree {
    private static final long serialVersionUID = 6808676036209284210L;
    private ItemFormatter itemFormatter;

    public FormattedItemsTree() {
    }

    public FormattedItemsTree(ItemFormatter itemFormatter) {
        this.itemFormatter = itemFormatter;
    }

    public FormattedItemsTree(Hashtable<?, ?> value, ItemFormatter itemFormatter) {
        super(value);
        this.itemFormatter = itemFormatter;
    }

    public FormattedItemsTree(Object[] value, ItemFormatter itemFormatter) {
        super(value);
        this.itemFormatter = itemFormatter;
    }

    public FormattedItemsTree(TreeModel newModel, ItemFormatter itemFormatter) {
        super(newModel);
        this.itemFormatter = itemFormatter;
    }

    public FormattedItemsTree(TreeNode root, boolean asksAllowsChildren, ItemFormatter itemFormatter) {
        super(root, asksAllowsChildren);
        this.itemFormatter = itemFormatter;
    }

    public FormattedItemsTree(TreeNode root, ItemFormatter itemFormatter) {
        super(root);
        this.itemFormatter = itemFormatter;
    }

    public FormattedItemsTree(Vector<?> value, ItemFormatter itemFormatter) {
        super(value);
        this.itemFormatter = itemFormatter;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.getItemFormatter().format(value);
    }

    public ItemFormatter getItemFormatter() {
        if (this.itemFormatter == null) {
            this.itemFormatter = this.createDefaultItemFormatter();
        }
        return this.itemFormatter;
    }

    private ItemFormatter createDefaultItemFormatter() {
        return new ItemFormatter(){

            public String format(Object value) {
                if (value != null) {
                    return value.toString();
                }
                return "";
            }
        };
    }

    public void setItemFormatter(ItemFormatter itemFormatter) {
        this.itemFormatter = itemFormatter;
    }
}

