/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.configuration.ErrorComponentLocator;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JSpinner;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 998184269763765038L;
    private String hrefPrefix;
    private static final Logger logger = Logger.getLogger(ErrorReportEditorPane.class);
    private String title;
    private List<InvalidValue> invalidValues;

    public ErrorReportEditorPane() {
        this.setHrefPrefix("error");
        this.setContentType("text/html");
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                ErrorReportEditorPane.this.errorReportEditorPaneHyperlinkUpdate(e);
            }
        });
    }

    public ErrorReportEditorPane(String type, String text) {
        super(type, text);
        this.setHrefPrefix("error");
    }

    public ErrorReportEditorPane(String url) throws IOException {
        super(url);
        this.setHrefPrefix("error");
    }

    public ErrorReportEditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.setHrefPrefix("error");
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateText();
    }

    public void setMessages(List<InvalidValue> invalidValues) {
        this.invalidValues = invalidValues;
        this.updateText();
    }

    private void updateText() {
        this.setText(this.generateText());
    }

    private String generateText() {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        result.append("<head>");
        result.append("<LINK href='").append(ErrorReportEditorPane.class.getResource("ErrorReportEditorPaneStyle.css")).append("' rel='stylesheet' type='text/css'>");
        result.append("</head>");
        result.append("<body>");
        result.append("<div class='title'>").append(this.title).append("</div>");
        if (this.invalidValues != null && this.invalidValues.size() > 0) {
            result.append("<ul>");
            int index = 0;
            for (InvalidValue invalidValue : this.invalidValues) {
                result.append("<li class='message'><a href='").append(this.getHrefPrefix()).append(index).append("'>").append(this.getUserMessage(invalidValue)).append("</a></li>");
                ++index;
            }
            result.append("</ul>");
        }
        result.append("</body>");
        result.append("</html>");
        return result.toString();
    }

    private String getUserMessage(InvalidValue invalidValue) {
        return String.format("Invalid %s=[%s]: %s.", invalidValue.getPropertyName(), invalidValue.getValue(), invalidValue.getMessage());
    }

    public void removeMessages() {
        this.invalidValues = null;
        this.updateText();
    }

    public void setHrefPrefix(String hrefPrefix) {
        this.hrefPrefix = hrefPrefix;
    }

    public String getHrefPrefix() {
        return this.hrefPrefix;
    }

    public String getUnprefixedValue(String message) {
        return message.substring(this.hrefPrefix.length());
    }

    private void errorReportEditorPaneHyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    this.goToMessage(e.getDescription());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void goToMessage(String message) {
        logger.debug((Object)("goToURL(" + message + ")"));
        InvalidValue invalidValue = this.getInvalidValue(message);
        Object uiBean = invalidValue.getBean();
        if (uiBean instanceof JComponent) {
            ((JComponent)uiBean).requestFocusInWindow();
            if (uiBean instanceof JSpinner) {
                ((JSpinner)uiBean).transferFocus();
            }
        } else if (uiBean instanceof ErrorComponentLocator) {
            ErrorComponentLocator locator = (ErrorComponentLocator)uiBean;
            locator.locateComponent();
        }
    }

    private InvalidValue getInvalidValue(String message) {
        return this.invalidValues.get(new Integer(this.getUnprefixedValue(message)));
    }

    public String getTitle() {
        return this.title;
    }
}

