/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.configuration.ConfigSection;
import com.bwanms.gui.configuration.ConfigSectionFactory;
import com.bwanms.mo.EquipmentConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigTreeModel
implements TreeModel {
    private static final Logger log = Logger.getLogger(ConfigTreeModel.class);
    private Vector treeModelListeners = new Vector();
    private ConfigSection root;

    public ConfigTreeModel(EquipmentConfiguration configuration, String applicationType) {
        this.root = new ConfigSectionFactory().createEquipmentConfigSection(configuration, applicationType);
    }

    public void fireTreeStructureChanged(ConfigSection oldRoot) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        ConfigSection p = (ConfigSection)parent;
        return p.getChildSections().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        ConfigSection p = (ConfigSection)parent;
        return p.getChildSections().size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        ConfigSection p = (ConfigSection)parent;
        return p.getChildSections().indexOf(child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        ConfigSection p = (ConfigSection)node;
        return p.getChildSections() == null;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        log.debug((Object)String.format("*** valueForPathChanged : %s --> %s", path.toString(), newValue.toString()));
    }

    public ConfigSection findNode(String[] leaves) {
        return this.findNode((ConfigSection)this.getRoot(), leaves, 0);
    }

    public TreePath findNodePath(String[] strPath) {
        ArrayList<ConfigSection> objPath = new ArrayList<ConfigSection>();
        this.findNodePath(objPath, (ConfigSection)this.getRoot(), strPath, 0);
        return new TreePath(objPath.toArray());
    }

    private void findNodePath(List<ConfigSection> objPath, ConfigSection current, String[] strPath, int index) {
        objPath.add(current);
        if (index >= strPath.length) {
            return;
        }
        for (ConfigSection configSection : current.getChildSections()) {
            if (!configSection.getName().equals(strPath[index])) continue;
            this.findNodePath(objPath, configSection, strPath, index + 1);
        }
    }

    private ConfigSection findNode(ConfigSection current, String[] leaves, int index) {
        if (index >= leaves.length) {
            return current;
        }
        for (ConfigSection configSection : current.getChildSections()) {
            if (!configSection.getName().equals(leaves[index])) continue;
            ConfigSection result = this.findNode(configSection, leaves, index + 1);
            if (result != null) {
                return result;
            }
            return configSection;
        }
        return null;
    }
}

