/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ActionCommandCallback;
import com.bwanms.gui.configuration.ConfigApplicationPanel;
import com.bwanms.gui.configuration.ConfigSection;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.ConfigTreeModel;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.LongActionCallback;
import com.bwanms.gui.help.HelpAction;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentNotifyerEventTypes;
import com.bwanms.model.TreeChangingLabel;
import com.bwanms.model.entity.Assembly;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.InvalidValuesUtil;
import com.bwanms.util.ConfigurationPluginUtil;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigApplicationView
implements View,
ActionCommandCallback {
    public static final String ASSEMBLER_NAME = ConfigApplicationView.class.getName() + ".assembler";
    private static final String platformType = System.getProperty("com.bwanms.platform", "remote");
    private static final Logger logger = Logger.getLogger(ConfigApplicationView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ConfigApplicationView.class);
    public static final String APP_TYPE_CONFIG = "Configuration";
    public static final String APP_TYPE_PERFORMANCE = "Performance";
    private ConfigApplicationPanel panel = null;
    private ConfigSectionView currentEditor;
    private ConfigSection currentConfigSection;
    private List<InvalidValue> invalidValues;
    private LongActionCallback longActionCallback;
    private String applicationType = "Configuration";
    private HashMap<String, Object> fireActionAttributes = new HashMap();
    private boolean hideSyncButton = false;
    private boolean applyPermision = Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "write");
    private Map<Integer, Object> treeChangingProperties = new HashMap<Integer, Object>();
    private boolean haveToRefreshTree;
    private MessageListener topicMessageListener;
    private EquipmentConfiguration configuration;
    private InvalidValuesUtil invalidValuesUtil;
    ConfigTreeModel configTreeModel;

    public ConfigApplicationView(Equipment equipment, String applicationType, boolean hideSyncButton) {
        long _openTime = System.currentTimeMillis();
        this.createConfiguration(equipment);
        logger.debug((Object)("[GUIT] Config App Open: " + (System.currentTimeMillis() - _openTime) + " millis"));
        String messageSelectorValue = ConfigurationPluginUtil.getInstance().getEquipmentPropertiesHandlers().getMessageSelectorValue(equipment);
        if (messageSelectorValue != null) {
            this.topicMessageListener = new TopicMessageListener();
            PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/EquipmentObserverTopic", this.topicMessageListener, "listener_discriminator", messageSelectorValue, false);
            logger.info((Object)"REGISTERED ON TOPIC AND LISTENING");
        }
        this.hideSyncButton = hideSyncButton;
        this.panel = new ConfigApplicationPanel();
        this.applicationType = applicationType;
        this.invalidValues = new ArrayList<InvalidValue>();
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.longActionCallback = new LongActionCallback(){

            public void onStarting(String message) {
                ConfigApplicationView.this.inform(message);
                ConfigApplicationView.this.getProgressBar().setIndeterminate(true);
                ConfigApplicationView.this.panel.getBtnApply().setEnabled(false);
                ConfigApplicationView.this.panel.getBtnRefresh().setEnabled(false);
                ConfigApplicationView.this.panel.getBtnSynch().setEnabled(false);
            }

            public void onFinished(String message) {
                ConfigApplicationView.this.inform(message);
                ConfigApplicationView.this.getProgressBar().setIndeterminate(false);
                ConfigApplicationView.this.panel.getBtnApply().setEnabled(ConfigApplicationView.this.currentConfigSection.getConfigEditor().canApply() && ConfigApplicationView.this.applyPermision);
                ConfigApplicationView.this.panel.getBtnRefresh().setEnabled(true);
                ConfigApplicationView.this.panel.getBtnSynch().setEnabled(true);
            }
        };
        this.initPanelComponentsEx();
        this.panel.getTreeMenu().setSelectionPath(new TreePath(this.getTreeModel().getRoot()));
    }

    public ConfigApplicationView(Equipment equipment, String applicationType) {
        this(equipment, applicationType, false);
    }

    public ConfigApplicationView(Equipment equipment, boolean hideSyncButton) {
        this(equipment, APP_TYPE_CONFIG, hideSyncButton);
    }

    public ConfigApplicationView(Equipment equipment) {
        this(equipment, APP_TYPE_CONFIG);
    }

    @Deprecated
    public ConfigApplicationView(EquipmentConfiguration configuration) {
        this(configuration, false);
    }

    @Deprecated
    public ConfigApplicationView(EquipmentConfiguration configuration, boolean hideSyncButton) {
        this.hideSyncButton = hideSyncButton;
        this.configuration = configuration;
        this.panel = new ConfigApplicationPanel();
        this.invalidValues = new ArrayList<InvalidValue>();
        this.invalidValuesUtil = new InvalidValuesUtil();
        this.longActionCallback = new LongActionCallback(){

            public void onStarting(String message) {
                ConfigApplicationView.this.inform(message);
                ConfigApplicationView.this.getProgressBar().setIndeterminate(true);
                ConfigApplicationView.this.panel.getBtnApply().setEnabled(false);
                ConfigApplicationView.this.panel.getBtnRefresh().setEnabled(false);
                ConfigApplicationView.this.panel.getBtnSynch().setEnabled(false);
            }

            public void onFinished(String message) {
                ConfigApplicationView.this.inform(message);
                ConfigApplicationView.this.getProgressBar().setIndeterminate(false);
                ConfigApplicationView.this.panel.getBtnApply().setEnabled(ConfigApplicationView.this.currentConfigSection.getConfigEditor().canApply() && ConfigApplicationView.this.applyPermision);
                ConfigApplicationView.this.panel.getBtnRefresh().setEnabled(true);
                ConfigApplicationView.this.panel.getBtnSynch().setEnabled(true);
            }
        };
        this.initPanelComponentsEx();
        this.panel.getTreeMenu().setSelectionPath(new TreePath(this.getTreeModel().getRoot()));
    }

    private void createConfiguration(Equipment equipment) {
        try {
            Assembly<?> equipmentAssembly = ServiceRegistry.getEntityManagerService().get(equipment.getClass(), equipment.getId(), ASSEMBLER_NAME);
            if (null != equipmentAssembly) {
                equipment = (Equipment)equipmentAssembly.getEntity();
                this.configuration = equipment.findCurrentConfiguration();
            } else {
                this.configuration = ServiceRegistry.getInventoryManagementService().findFullCurrentConfiguration(equipment.getEUID());
            }
            this.treeChangingProperties.putAll(ConfigurationPluginUtil.getInstance().getEquipmentPropertiesHandlers().getEqupipmentProperties(equipment));
        }
        catch (ServiceException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    void initPanelComponentsEx() {
        this.panel.getBtnHelp().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigApplicationView.this.helpActionPerformed();
            }
        });
        this.panel.getBtnRefresh().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigApplicationView.this.refreshActionPerformed(false);
            }
        });
        this.panel.getBtnSynch().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigApplicationView.this.refreshActionPerformed(true);
            }
        });
        this.panel.getBtnApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigApplicationView.this.applyActionPerformed();
            }
        });
        this.panel.getTreeMenu().setModel(this.getTreeModel());
        this.panel.getTreeMenu().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ConfigSection configSection = (ConfigSection)ConfigApplicationView.this.panel.getTreeMenu().getLastSelectedPathComponent();
                if (configSection == null) {
                    return;
                }
                boolean acceptSelection = ConfigApplicationView.this.configSectionSelected(configSection, ConfigApplicationView.this.fireActionAttributes);
                if (!acceptSelection) {
                    ConfigApplicationView.this.panel.getTreeMenu().getSelectionModel().setSelectionPath(e.getOldLeadSelectionPath());
                }
            }
        });
        boolean localPlatform = platformType.equalsIgnoreCase("local");
        this.panel.getBtnSynch().setVisible(!localPlatform && !this.hideSyncButton);
        this.panel.getBtnHelp().setAction(new HelpAction(""));
        this.panel.getBtnHelp().setText("");
    }

    boolean configSectionSelected(ConfigSection configSection, HashMap<String, Object> atributes) {
        if (this.currentConfigSection == configSection) {
            return true;
        }
        boolean changed = true;
        try {
            changed = this.isChanged(this.currentEditor);
        }
        catch (Exception e) {
            logger.error((Object)"Error in detecting changes.", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (changed) {
            Object[] options = new Object[]{i18n.translateString("discardChanges"), i18n.translateString("keepEditing")};
            int result = JOptionPane.showOptionDialog(this.panel, i18n.translateString("UnsavedChangesMessage"), i18n.translateString("UnsavedChangesTitle"), -1, 3, null, options, options[0]);
            if (result == -1 || result == 1) {
                return false;
            }
            if (result == 0) {
                // empty if block
            }
        }
        this.setCurrentConfigSection(configSection, atributes);
        return true;
    }

    private void setCurrentConfigSection(ConfigSection configSection, HashMap<String, Object> atributes) {
        ConfigSectionView oldEditor = this.currentEditor;
        if (oldEditor != null) {
            oldEditor.unregisterLongActionCallback();
        }
        this.currentConfigSection = configSection;
        this.currentEditor = configSection.getConfigEditor();
        if (this.currentEditor instanceof FormsConfigSectionView && atributes != null) {
            ((FormsConfigSectionView)this.currentEditor).attributes.putAll(atributes);
            atributes.clear();
        }
        this.panel.getPanelSectionEditor().removeAll();
        if (oldEditor != null) {
            oldEditor.cleanup();
        }
        this.panel.getPanelSectionEditor().add((Component)this.currentEditor.getUI(), "Center");
        this.currentEditor.setParentComponent(this.panel);
        this.panel.getPanelSectionEditor().validate();
        this.panel.getPanelSectionEditor().repaint();
        this.currentEditor.registerLongActionCallback(this.longActionCallback);
        this.currentEditor.registerActionCallback(this);
        this.panel.getBtnApply().setEnabled(this.currentEditor.canApply());
        this.panel.getBtnHelp().setAction(new HelpAction(this.currentEditor.getHelpTopic()));
        this.panel.getBtnHelp().setText("");
        if (!this.applyPermision) {
            this.panel.getBtnApply().setEnabled(false);
        }
        this.refreshActionPerformed(false);
    }

    private boolean isChanged(View configSectionEditor) {
        if (configSectionEditor == null) {
            return false;
        }
        return this.currentEditor.isChanged();
    }

    void helpActionPerformed() {
    }

    void refreshActionPerformed(boolean forceRefresh) {
        this.checkTreeModel();
        this.clearReportedInvalidValues();
        this.panel.getErrorReportEditorPane().setTitle(this.currentEditor.getTitle());
        this.currentEditor.refresh(forceRefresh);
    }

    void applyActionPerformed() {
        this.callApply();
    }

    private boolean callApply() {
        this.clearReportedInvalidValues();
        this.currentEditor.apply(this.invalidValues);
        if (this.invalidValues.size() > 0) {
            this.reportInvalidValues();
            return false;
        }
        this.checkTreeModel();
        return true;
    }

    private void reportInvalidValues() {
        if (this.invalidValues.size() > 0) {
            this.panel.getErrorReportEditorPane().setMessages(this.invalidValues);
            this.invalidValuesUtil.reportInvalidValues(this.invalidValues);
            this.inform("You have " + this.invalidValues.size() + " validation errors. Please correct them before apply.");
        }
    }

    private void clearReportedInvalidValues() {
        if (this.invalidValues.size() > 0) {
            this.panel.getErrorReportEditorPane().removeMessages();
            this.invalidValuesUtil.clearReportedInvalidValues(this.invalidValues);
            this.inform("Starting validate ...");
        }
    }

    private JProgressBar getProgressBar() {
        return this.panel.getProgressBar();
    }

    private void inform(String message) {
        this.panel.getLblMessage().setText(message);
    }

    @Override
    public void fireAction(String url) {
        logger.debug((Object)("fireAction(" + url + ")"));
        String prefix = "bwanms://config/" + this.getConfiguration().getEquipment().getEUID() + "/";
        this.fireActionAttributes.clear();
        if (url.startsWith(prefix)) {
            String[] path;
            int argIndexStart = url.lastIndexOf(63);
            if (argIndexStart != -1) {
                String[] args;
                path = url.substring(prefix.length(), argIndexStart).split("[/]");
                for (String s : args = url.substring(argIndexStart + 1).split("&")) {
                    if (s.indexOf(61) == -1 || s.indexOf(61) >= s.length() - 1) continue;
                    this.fireActionAttributes.put(s.substring(0, s.indexOf(61)), s.substring(s.indexOf(61) + 1));
                }
            } else {
                path = url.substring(prefix.length()).split("[/]");
            }
            this.panel.getTreeMenu().setSelectionPath(this.getTreeModel().findNodePath(path));
        }
    }

    private ConfigSection findConfigSection(String url) {
        ConfigSection result = null;
        String prefix = "bwanms://config/" + this.getConfiguration().getEquipment().getEUID() + "/";
        if (url.startsWith(prefix)) {
            String[] leaves = url.substring(prefix.length()).split("[/]");
            result = this.getTreeModel().findNode(leaves);
            logger.debug((Object)("Found ConfigSection " + result));
        }
        return result;
    }

    public void setConfiguration(EquipmentConfiguration configuration) {
        this.configuration = configuration;
    }

    public EquipmentConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConfigTreeModel getTreeModel() {
        if (this.configTreeModel == null) {
            this.configTreeModel = new ConfigTreeModel(this.getConfiguration(), this.applicationType);
        }
        return this.configTreeModel;
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public boolean close() {
        if (this.currentEditor != null) {
            return this.currentEditor.close();
        }
        return true;
    }

    @Override
    public void cleanup() {
        if (this.currentEditor != null) {
            this.currentEditor.cleanup();
        }
        if (this.topicMessageListener != null) {
            PlatformFactory.getApplicationLayerPlatform().getMessaging().removeTopicListener(this.topicMessageListener);
            logger.info((Object)"REMOVED FROM TOPIC");
        }
    }

    @Override
    public String getTitle() {
        if (this.currentEditor != null) {
            return this.currentEditor.getTitle();
        }
        return null;
    }

    private void checkTreeModel() {
        if (this.haveToRefreshTree) {
            this.haveToRefreshTree = false;
            this.refreshTree();
        }
    }

    private void refreshTree() {
        String oldURL = this.getConfigSectionURL(this.currentConfigSection);
        this.createConfiguration(this.configuration.getEquipment());
        this.configTreeModel = new ConfigTreeModel(this.configuration, this.applicationType);
        this.panel.getTreeMenu().setModel(this.getTreeModel());
        this.fireAction(oldURL);
    }

    public String getConfigSectionURL(ConfigSection configSection) {
        StringBuilder sb = new StringBuilder();
        for (ConfigSection currentConfigSection = configSection; currentConfigSection != null; currentConfigSection = currentConfigSection.getParent()) {
            if (currentConfigSection.getParent() == null) continue;
            sb.insert(0, "/" + currentConfigSection.getName());
        }
        return "bwanms://config/" + this.getConfiguration().getEquipment().getEUID() + sb.toString();
    }

    public String[] getConfigSectionStringPath(ConfigSection configSection) {
        ArrayList<String> pathList = new ArrayList<String>();
        for (ConfigSection currentConfigSection = configSection; currentConfigSection != null; currentConfigSection = currentConfigSection.getParent()) {
            if (currentConfigSection.getParent() == null) continue;
            pathList.add(0, currentConfigSection.getName());
        }
        return pathList.toArray(new String[pathList.size()]);
    }

    private class TopicMessageListener
    implements MessageListener {
        private TopicMessageListener() {
        }

        public void onMessage(Message message) {
            HashMap equipmentProperties = null;
            try {
                equipmentProperties = (HashMap)((ObjectMessage)message).getObject();
            }
            catch (Throwable e) {
                logger.debug((Object)e);
            }
            if (equipmentProperties != null) {
                for (EquipmentNotifyerEventTypes key : equipmentProperties.keySet()) {
                    Object equipmentProperty = equipmentProperties.get((Object)key);
                    switch (key) {
                        case TREE_LABEL_CHANGED: {
                            this.treeLabelChanged(equipmentProperty);
                            break;
                        }
                        case TREE_NODE_DELETED: {
                            this.treeNodeDeleted(equipmentProperty);
                            break;
                        }
                        case LABEL_CRITICAL_MESSAGE_CHANGED: {
                            this.criticalMessageChanged(equipmentProperty);
                            break;
                        }
                        case TREE_STRUCTURE_CHANGED: {
                            this.treeStructureChanged(equipmentProperty);
                        }
                    }
                }
            }
        }

        private void treeStructureChanged(Object equipmentProperty) {
            boolean treeChanged = false;
            StringBuilder sb = new StringBuilder(i18n.translateString("FollowingEquipmentPropertiesWareChanged") + "\n");
            HashMap messageTreeChangingProperties = (HashMap)equipmentProperty;
            for (Integer treeChangingKey : messageTreeChangingProperties.keySet()) {
                Object oldValue = ConfigApplicationView.this.treeChangingProperties.get(treeChangingKey);
                Object newValue = messageTreeChangingProperties.get(treeChangingKey);
                if (oldValue == null) {
                    if (newValue == null) continue;
                    treeChanged = true;
                    ConfigApplicationView.this.treeChangingProperties.put(treeChangingKey, newValue);
                    continue;
                }
                if (oldValue.equals(newValue)) continue;
                ConfigApplicationView.this.treeChangingProperties.put(treeChangingKey, newValue);
                sb.append(ConfigurationPluginUtil.getInstance().getEquipmentPropertiesHandlers().getPropertyTranslation(treeChangingKey) + "\n");
                treeChanged = true;
            }
            if (treeChanged) {
                Object[] options = new String[]{i18n.translateString("Now"), i18n.translateString("Later")};
                if (MessageBox.showTimeoutDialog(ConfigApplicationView.this.panel, sb.toString(), i18n.translateString("EditorMustBeRefreshed"), 0, 3, options, options[0], 30, false) == 0) {
                    ConfigApplicationView.this.refreshTree();
                    ConfigApplicationView.this.refreshActionPerformed(false);
                } else {
                    ConfigApplicationView.this.haveToRefreshTree = true;
                }
            }
        }

        private void criticalMessageChanged(Object equipmentProperty) {
            String text = String.valueOf(equipmentProperty);
            ConfigApplicationView.this.panel.getLblCriticalMessages().setText(text);
            ConfigApplicationView.this.panel.getLblCriticalMessages().setToolTipText(text);
        }

        private void treeNodeDeleted(Object equipmentProperty) {
            ConfigSection parent;
            String[] treePath;
            ConfigSection changedConfigSection;
            if (equipmentProperty instanceof String[] && (changedConfigSection = ConfigApplicationView.this.configTreeModel.findNode(treePath = (String[])equipmentProperty)) != null && (parent = changedConfigSection.getParent()) != null) {
                parent.getChildSections().remove(changedConfigSection);
                ConfigApplicationView.this.configTreeModel.fireTreeStructureChanged(parent);
                ConfigApplicationView.this.setCurrentConfigSection(parent, null);
                ConfigApplicationView.this.panel.getTreeMenu().getSelectionModel().setSelectionPath(parent.getTreePath());
                ConfigApplicationView.this.panel.getTreeMenu().expandPath(parent.getTreePath());
            }
        }

        private void treeLabelChanged(Object equipmentProperty) {
            if (equipmentProperty instanceof TreeChangingLabel) {
                TreeChangingLabel treeChangingLabel = (TreeChangingLabel)equipmentProperty;
                ConfigSection changedConfigSection = ConfigApplicationView.this.configTreeModel.findNode(treeChangingLabel.getNodeNamePath());
                String newLabel = treeChangingLabel.getNewLabel();
                if (changedConfigSection != null && !changedConfigSection.getLabel().equals(newLabel)) {
                    ConfigApplicationView.this.configTreeModel.valueForPathChanged(changedConfigSection.getTreePath(), newLabel);
                    changedConfigSection.setLabel(newLabel);
                    ConfigApplicationView.this.panel.getTreeMenu().repaint();
                }
            }
        }
    }
}

