/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.configuration;

import com.bwanms.gui.configuration.ConfigSection;
import com.bwanms.gui.configuration.ConfigSectionListener;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.ConfigSectionViewFactory;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public abstract class AbstractConfigSection
implements ConfigSection {
    private ArrayList<ConfigSectionListener> listeners = new ArrayList();
    private ConfigSectionViewFactory viewFactory;

    public AbstractConfigSection(ConfigSectionViewFactory viewFactory) {
        this.viewFactory = viewFactory;
    }

    public void addConfigSectionListener(ConfigSectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigSectionListener(ConfigSectionListener listener) {
        this.listeners.remove(listener);
    }

    public ConfigSectionView getConfigEditor() {
        return this.viewFactory.createView();
    }

    protected void fireSectionChanged() {
        for (ConfigSectionListener listener : this.listeners) {
            listener.sectionChanged(this);
        }
    }

    protected void fireChildSectionAdded(ConfigSection childSection, int position) {
        for (ConfigSectionListener listener : this.listeners) {
            listener.childSectionAdded(this, childSection, position);
        }
    }

    protected void fireChildSectionRemoved(int childPosition) {
        for (ConfigSectionListener listener : this.listeners) {
            listener.childSectionRemoved(this, childPosition);
        }
    }

    public TreePath getTreePath() {
        ArrayList<AbstractConfigSection> listPath = new ArrayList<AbstractConfigSection>();
        for (ConfigSection currentConfigSection = this; currentConfigSection != null; currentConfigSection = currentConfigSection.getParent()) {
            listPath.add(0, (AbstractConfigSection)currentConfigSection);
        }
        return new TreePath(listPath.toArray());
    }
}

