/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding.translators;

import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.util.BeanFactory;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserValueTranslator<BeanClass>
implements ValueTranslator<BeanClass, String> {
    private static final Logger logger = Logger.getLogger(ParserValueTranslator.class);
    private Class beanClass;

    public ParserValueTranslator(Class beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public String convertToUIValue(BeanClass beanValue) {
        if (beanValue == null) {
            return null;
        }
        return beanValue.toString();
    }

    @Override
    public BeanClass convertToBeanValue(String propertyValue) throws TranslateException {
        boolean sendNull = false;
        try {
            if (propertyValue == null || propertyValue.trim().length() == 0) {
                return null;
            }
            return (BeanClass)BeanFactory.newInstance(this.beanClass, String.class, propertyValue);
        }
        catch (IllegalArgumentException e) {
            throw new TranslateException(e);
        }
        catch (SecurityException e) {
            throw new TranslateException(e);
        }
        catch (InstantiationException e) {
            throw new TranslateException(e);
        }
        catch (IllegalAccessException e) {
            throw new TranslateException(e);
        }
        catch (InvocationTargetException e) {
            throw new TranslateException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new TranslateException(e);
        }
        catch (Throwable e) {
            throw new TranslateException(e);
        }
    }
}

