/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding.translators;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.util.MacAddress;

public class MACAddressTranslator
implements ValueTranslator {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MACAddressTranslator.class);
    private boolean allowNull = false;

    public MACAddressTranslator() {
    }

    public MACAddressTranslator(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public Object convertToUIValue(Object beanValue) throws TranslateException {
        if (beanValue != null) {
            return MacAddress.fromSimpleString((String)beanValue).toString();
        }
        return null;
    }

    public Object convertToBeanValue(Object uiBeanValue) throws TranslateException {
        if (this.allowNull && (uiBeanValue == null || uiBeanValue.toString().trim().equals(""))) {
            return null;
        }
        if (uiBeanValue != null && ((String)uiBeanValue).matches("[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]")) {
            return MacAddress.fromString((String)uiBeanValue).toSimpleString();
        }
        throw new TranslateException(i18n.translateString("invalidMACAddress"));
    }
}

