/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding.translators;

import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongValueTranslator
implements ValueTranslator<Long, String> {
    private static final LongValueTranslator singleton = new LongValueTranslator();

    private LongValueTranslator() {
    }

    public static LongValueTranslator instance() {
        return singleton;
    }

    @Override
    public String convertToUIValue(Long beanValue) {
        if (beanValue == null) {
            return "null";
        }
        return beanValue.toString();
    }

    @Override
    public Long convertToBeanValue(String uiBeanValue) throws TranslateException {
        try {
            return Long.valueOf(uiBeanValue);
        }
        catch (NumberFormatException e) {
            throw new TranslateException(e);
        }
    }
}

