/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding.translators;

import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerValueTranslator
implements ValueTranslator<Integer, String> {
    private static final IntegerValueTranslator singleton = new IntegerValueTranslator("");
    private final String uiNullValue;

    public IntegerValueTranslator(String uiNullValue) {
        if (uiNullValue == null) {
            throw new NullPointerException();
        }
        this.uiNullValue = uiNullValue;
    }

    public static IntegerValueTranslator instance() {
        return singleton;
    }

    @Override
    public String convertToUIValue(Integer beanValue) {
        if (beanValue == null) {
            return this.uiNullValue;
        }
        return beanValue.toString();
    }

    @Override
    public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
        if (uiBeanValue == null || this.uiNullValue.equals(uiBeanValue)) {
            return null;
        }
        try {
            return Integer.valueOf(uiBeanValue);
        }
        catch (NumberFormatException e) {
            throw new TranslateException(e);
        }
    }
}

