/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding.translators;

import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatToStringValueTranslator
implements ValueTranslator<String, Float> {
    private static final FloatToStringValueTranslator singleton = new FloatToStringValueTranslator();

    private FloatToStringValueTranslator() {
    }

    public static FloatToStringValueTranslator instance() {
        return singleton;
    }

    @Override
    public String convertToBeanValue(Float uiBeanValue) throws TranslateException {
        if (uiBeanValue == null) {
            return "0";
        }
        if (uiBeanValue.floatValue() == (float)uiBeanValue.intValue()) {
            return Integer.toString(uiBeanValue.intValue());
        }
        return uiBeanValue.toString();
    }

    @Override
    public Float convertToUIValue(String beanValue) throws TranslateException {
        if (beanValue == null) {
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(beanValue);
        }
        catch (NumberFormatException e) {
            throw new TranslateException(e);
        }
    }
}

