/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding.translators;

import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatToIntValueTranslator
implements ValueTranslator<Integer, Float> {
    private int multiplier;

    private FloatToIntValueTranslator() {
    }

    public FloatToIntValueTranslator(int multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public Float convertToUIValue(Integer beanValue) throws TranslateException {
        return new Float(beanValue.floatValue() / (float)this.multiplier);
    }

    @Override
    public Integer convertToBeanValue(Float uiBeanValue) throws TranslateException {
        return new Integer(Math.round(uiBeanValue.floatValue() * (float)this.multiplier));
    }
}

