/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.mo.snmp.SNMPTableRowMO;
import com.bwanms.ui.components.defaultvalues.DefaultUtils;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedTableRowBinder
extends AbstractBinder<Binding> {
    private static final Logger logger = Logger.getLogger(UnifiedTableRowBinder.class);
    private SNMPTableRowMO moInst;
    private String rowKey;

    public UnifiedTableRowBinder(Object uiBean, UnifiedMOSupport<? extends SNMPTableRowMO> moSupport, String rowKey) {
        super(uiBean, moSupport);
        this.setBean(moSupport, rowKey);
    }

    @Override
    public Object getBean() {
        return this.moInst;
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
        if (this.enabled) {
            int previousInvalidValuesSize = invalidValues.size();
            UnifiedMOSupport moSupport = (UnifiedMOSupport)this.bean;
            if (moSupport.findRowKey(this.rowKey)) {
                this.moInst = (SNMPTableRowMO)moSupport.findInstance(this.rowKey);
            } else {
                this.newMOInstance();
            }
            for (Binding binding : this.bindings) {
                binding.configureBean(invalidValues);
            }
            if (previousInvalidValuesSize == invalidValues.size()) {
                if (moSupport.findRowKey(this.rowKey)) {
                    if (!this.rowKey.equals(this.moInst.getRowKey())) {
                        throw new UnsupportedOperationException("Update of row key is forbidden (" + this.rowKey + " -> " + this.moInst.getRowKey() + ") [" + this.moInst.getClass().getName() + "]");
                    }
                } else {
                    moSupport.addInstance(this.moInst);
                }
            } else {
                for (int i = invalidValues.size() - 1; i >= previousInvalidValuesSize; --i) {
                    logger.debug((Object)("binding validation error: " + invalidValues.get(i)));
                }
            }
        }
    }

    @Override
    public void fillUIFromBean(Object newBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean fillBeanFromUI(Object newBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBean(Object bean) {
        throw new UnsupportedOperationException();
    }

    public void setBean(UnifiedMOSupport<? extends SNMPTableRowMO> bean, String rowKey) {
        if (!SNMPTableRowMO.class.isAssignableFrom(bean.getParameterClass())) {
            throw new AssertionError((Object)(bean.getParameterClass().getName() + " class is not a " + SNMPTableRowMO.class.getName() + " class"));
        }
        this.bean = bean;
        this.moInst = bean.findInstance(rowKey);
        this.rowKey = rowKey;
        if (this.moInst == null) {
            this.newMOInstance();
        }
    }

    private void newMOInstance() {
        try {
            this.moInst = (SNMPTableRowMO)((UnifiedMOSupport)this.bean).getParameterClass().newInstance();
            DefaultUtils.setDefaults(this.moInst);
            List<Method> indexes = BeanUtils.getAnnotatedPropertyGetters(this.moInst.getClass(), IdentifierAttribute.class);
            if (indexes.size() > 1) {
                throw new AssertionError((Object)"This will not work with multiple indexes; It need to be enhanced for that.");
            }
            String indexKey = BeanUtils.getPropertyNameFromGetter(indexes.get(0));
            Constructor<?> indexTypeConstr = indexes.get(0).getReturnType().getConstructor(String.class);
            BeanUtils.setPropertyValue(this.moInst, indexKey, indexTypeConstr.newInstance(this.rowKey));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create new instance of class " + ((UnifiedMOSupport)this.bean).getParameterClass().getName(), e);
        }
    }
}

