/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.AbstractUnifiedTableBinder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.translators.NullTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.util.BeanUtils;
import com.bwanms.validation.UIInvalidValue;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedTableColumnBinding
implements Binding<AbstractUnifiedTableBinder> {
    private static final Logger logger = Logger.getLogger(UnifiedTableColumnBinding.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(UnifiedTableColumnBinding.class);
    private static final Internationalizer i18nVM = Internationalizer.getInternationalizer("com.bwanms.validator");
    private String beanEntryProperty;
    private int currentRowIndex;
    private AbstractUnifiedTableBinder binder;
    private String uiColumnName;
    private Object currentEntry;
    private Integer columnIndex;
    private ValueTranslator translator;

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public void setCurrentEntry(Object currentEntry) {
        this.currentEntry = currentEntry;
    }

    public UnifiedTableColumnBinding(String uiColumnName, String beanEntryProperty) {
        this(uiColumnName, beanEntryProperty, new NullTranslator());
    }

    public UnifiedTableColumnBinding(String uiColumnName, String beanEntryProperty, ValueTranslator translator) {
        this.beanEntryProperty = beanEntryProperty;
        this.uiColumnName = uiColumnName;
        this.translator = translator;
    }

    @Override
    public void initUI() {
    }

    @Override
    public void fillUIComponent() {
        try {
            this.binder.getTableModel().setInitialValueAt(this.translator.convertToUIValue(this.getBeanValue()), this.currentRowIndex, this.getColumnIndex());
        }
        catch (TranslateException e) {
            logger.error((Object)"Can't translate.", (Throwable)e);
        }
    }

    private Object getBeanValue() {
        return BeanUtils.getPropertyValue(this.currentEntry, this.beanEntryProperty);
    }

    private void setBeanValue(Object value, List<InvalidValue> invalidValues) {
        if (value == null) {
            Class<?> moClass = this.currentEntry.getClass();
            for (Method m : BeanUtils.getAnnotatedPropertyGetters(moClass, IdentifierAttribute.class)) {
                if (!m.equals(BeanUtils.getGetter(moClass, this.beanEntryProperty))) continue;
                invalidValues.add(new InvalidValue(i18nVM.translateString("validator.weakNotNull"), null, this.getTranslatedColumnName(this.uiColumnName), (Object)"", null));
            }
            return;
        }
        BeanUtils.setPropertyValue(this.currentEntry, this.beanEntryProperty, value);
    }

    private int getColumnIndex() {
        if (this.columnIndex == null) {
            String translatedColumnName = this.getTranslatedColumnName(this.uiColumnName);
            this.columnIndex = this.binder.getTableModel().findColumn(translatedColumnName);
            if (this.columnIndex == -1) {
                throw new RuntimeException("Can't find a column for name [" + translatedColumnName + "] for table [" + this.binder.getTableModel() + "]");
            }
        }
        return this.columnIndex;
    }

    private String getTranslatedColumnName(String columnName) {
        return this.binder.getI18n().translateString(columnName);
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
        Object uiValue = null;
        try {
            uiValue = this.binder.getTableModel().getValueAt(this.currentRowIndex, this.getColumnIndex());
            this.setBeanValue(this.translator.convertToBeanValue(uiValue), invalidValues);
        }
        catch (TranslateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot translate uiValue \"" + uiValue + "\" to bean value"), (Throwable)e);
            }
            invalidValues.add(this.toUIInvalidValue(new InvalidValue(i18n.translateString("InvalidValue", uiValue), null, null, uiValue, null)));
        }
    }

    @Override
    public void setBinder(AbstractUnifiedTableBinder binder) {
        this.binder = binder;
    }

    @Override
    public void toUIInvalidValues(List<InvalidValue> uiInvalidValues, List<InvalidValue> invalidValues) {
        for (InvalidValue invalidValue : invalidValues) {
            if (!this.accept(invalidValue.getBean(), invalidValue.getPropertyName())) continue;
            uiInvalidValues.add(this.toUIInvalidValue(invalidValue));
        }
    }

    private boolean accept(Object bean, String propertyName) {
        UnifiedMOSupport moSupport;
        return propertyName.equals(this.beanEntryProperty) && ((moSupport = (UnifiedMOSupport)this.binder.getBean()).getNewInstances().contains(bean) || moSupport.getChangedInstances().contains(bean));
    }

    protected UIInvalidValue toUIInvalidValue(InvalidValue invalidValue) {
        String propertyName = this.getTranslatedColumnName(this.uiColumnName);
        if (null == propertyName) {
            propertyName = this.uiColumnName;
        }
        return new UIInvalidValue(invalidValue, "bean", this.binder.getUiBean().getClass(), propertyName, invalidValue.getValue(), this.binder.getUiBean(), invalidValue.getMessage(), new Object[0]);
    }

    @Override
    public String getBeanProperty() {
        return this.beanEntryProperty;
    }
}

