/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.AbstractUnifiedTableBinder;
import com.bwanms.gui.binding.UnifiedTableColumnBinding;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.mo.snmp.SNMPTableRowMO;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.FormUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedTableBinder
extends AbstractUnifiedTableBinder {
    private static final Internationalizer i18nVM = Internationalizer.getInternationalizer("com.bwanms.validator");
    private Object indexValue;
    private String indexKey;
    private final Internationalizer i18n;
    private final JTable table;

    public UnifiedTableBinder(Internationalizer i18n, JTable table, UnifiedMOSupport<?> moSupport) {
        super(table.getModel(), moSupport);
        if (!(table.getModel() instanceof SimpleRowTableModel)) {
            throw new IllegalArgumentException("table's model is not a SimpleRowTableModel as expected");
        }
        this.i18n = i18n;
        this.table = table;
    }

    @Deprecated
    public UnifiedTableBinder(Internationalizer i18n, SimpleRowTableModel table, UnifiedMOSupport<?> moSupport) {
        super(table, moSupport);
        throw new UnsupportedOperationException("Use UnifiedTableBinder(Internationalizer, JTable, UnifiedMOSupport) constructor instead of this one.");
    }

    public void setIndexKey(String indexKey, Object indexValue) {
        this.indexValue = indexValue;
        this.indexKey = indexKey;
    }

    @Override
    public void fillUI() {
        FormUtil.cancelTableEditing(this.table);
        if (this.getBean() != null) {
            if (this.getBindings().size() == 0) {
                return;
            }
            this.getTableModel().clearTable();
            int counter = 0;
            for (SNMPTableRowMO entry : this.getEntries()) {
                if (this.indexValue != null && !entry.getRowKey().startsWith(this.indexValue + ".")) continue;
                this.getTableModel().addNewRow(entry.getRowKey(), true);
                for (UnifiedTableColumnBinding binding : this.getBindings()) {
                    binding.setCurrentRowIndex(counter);
                    binding.setCurrentEntry(entry);
                    binding.fillUIComponent();
                }
                ++counter;
            }
            this.getTableModel().sort();
        }
    }

    public void updateInfo(String rowKey) {
        this.indexValue = rowKey;
        this.fillUI();
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
        if (!this.enabled) {
            return;
        }
        FormUtil.stopTableEditing(this.table);
        UnifiedMOSupport unifiedMO = (UnifiedMOSupport)this.getBean();
        SimpleRowTableModel tableModel = this.getTableModel();
        int count = tableModel.getRowCount();
        ArrayList<ManagedObject> newInstances = new ArrayList<ManagedObject>(count);
        ManagedObject helperMoInstance = null;
        block6: for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            String rowKey = tableModel.getRowKey(rowIndex);
            int rowState = tableModel.getRowState(rowIndex);
            switch (rowState) {
                case 2: 
                case 3: {
                    if (helperMoInstance == null) {
                        try {
                            helperMoInstance = (ManagedObject)unifiedMO.getParameterClass().newInstance();
                            if (this.indexKey != null && this.indexValue != null) {
                                BeanUtils.setPropertyValue(helperMoInstance, this.indexKey, this.indexValue);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot create new instance of class " + unifiedMO.getParameterClass().getName(), e);
                        }
                    }
                    int invalidValuesSize = invalidValues.size();
                    for (UnifiedTableColumnBinding binding : this.getBindings()) {
                        binding.setCurrentRowIndex(rowIndex);
                        binding.setCurrentEntry(helperMoInstance);
                        binding.configureBean(invalidValues);
                    }
                    if (invalidValues.size() > invalidValuesSize) continue block6;
                    if (rowState == 2) {
                        rowKey = helperMoInstance.getRowKey();
                        tableModel.setRowKey(rowIndex, rowKey);
                        if (this.isDuplicateEntry(tableModel, rowIndex, rowKey, invalidValues)) continue block6;
                        if (this.indexKey != null && this.indexValue == null) {
                            if (rowKey != null) {
                                if (rowKey.indexOf(46) == -1) {
                                    BeanUtils.setPropertyValue(helperMoInstance, this.indexKey, Integer.valueOf(rowKey));
                                } else {
                                    BeanUtils.setPropertyValue(helperMoInstance, this.indexKey, rowKey);
                                }
                            } else {
                                throw new NullPointerException("rowKey is null. Hint: initialize row keys (for new rows) in screen's ConfigForm class.");
                            }
                        }
                        newInstances.add(helperMoInstance.clone());
                        continue block6;
                    }
                    if (rowState != 3) continue block6;
                    if (unifiedMO.findInstance(rowKey) == null) {
                        throw new RuntimeException("MO of row key " + rowKey + " not found");
                    }
                    if (!rowKey.equals(helperMoInstance.getRowKey())) {
                        throw new UnsupportedOperationException("Update of row key is forbidden (" + rowKey + " -> " + helperMoInstance.getRowKey() + ") [" + helperMoInstance.getClass().getName() + "]");
                    }
                    unifiedMO.updateInstance(helperMoInstance);
                    continue block6;
                }
                case 1: {
                    unifiedMO.removeInstance(rowKey);
                }
            }
        }
        for (ManagedObject newInstance : newInstances) {
            unifiedMO.addInstance(newInstance);
        }
    }

    private boolean isDuplicateEntry(SimpleRowTableModel tableModel, int currentRow, String rowKey, List<InvalidValue> invalidValues) {
        for (int row = 0; row < currentRow; ++row) {
            if (!rowKey.equals(tableModel.getRowKey(row))) continue;
            invalidValues.add(new InvalidValue(i18nVM.translateString("duplicate.entry"), null, "rowKey", (Object)rowKey, null));
            return true;
        }
        return false;
    }

    protected Collection<SNMPTableRowMO> getEntries() {
        return ((UnifiedMOSupport)this.getBean()).getInstances();
    }

    @Override
    public SimpleRowTableModel getTableModel() {
        return (SimpleRowTableModel)this.getUiBean();
    }

    @Override
    public Internationalizer getI18n() {
        return this.i18n;
    }
}

