/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.mo.ManagedObjectChangeStrategy;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.mo.snmp.SNMPTableRowMO;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedComplexTableRowBinder
extends AbstractBinder<Binding> {
    private SimpleRowTableModel tableModel;
    private SNMPTableRowMO moInst;

    public UnifiedComplexTableRowBinder(Object uiBean, UnifiedMOSupport<? extends SNMPTableRowMO> moSupport, SimpleRowTableModel tableModel) {
        super(uiBean, moSupport);
        this.tableModel = tableModel;
    }

    @Override
    public Object getBean() {
        return this.moInst;
    }

    public ManagedObjectChangeStrategy getChangeStrategy() {
        return ((UnifiedMOSupport)super.getBean()).getChangeStrategy();
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
        if (this.enabled) {
            String rowKey = "";
            try {
                rowKey = this.moInst.getRowKey();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            boolean toBeDeleted = false;
            boolean isNewRow = false;
            if ("" != rowKey) {
                for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                    if (!rowKey.equals(this.tableModel.getRowKey(row))) continue;
                    switch (this.tableModel.getRowState(row)) {
                        case 1: {
                            toBeDeleted = true;
                            break;
                        }
                        case 2: {
                            isNewRow = true;
                        }
                    }
                    break;
                }
                if (!toBeDeleted) {
                    int previousInvalidValuesSize = invalidValues.size();
                    for (Binding binding : this.bindings) {
                        binding.configureBean(invalidValues);
                    }
                    if (invalidValues.size() == previousInvalidValuesSize) {
                        UnifiedMOSupport moSupport = (UnifiedMOSupport)this.bean;
                        if (moSupport.findRowKey(rowKey)) {
                            if (!rowKey.equals(this.moInst.getRowKey())) {
                                throw new UnsupportedOperationException("Update of row key is forbidden (" + rowKey + " -> " + this.moInst.getRowKey() + ") [" + this.moInst.getClass().getName() + "]");
                            }
                            if (isNewRow) {
                                moSupport.addInstance(this.moInst);
                            } else {
                                moSupport.updateInstance(this.moInst);
                            }
                        } else {
                            moSupport.addInstance(this.moInst);
                        }
                    }
                }
            }
        }
    }

    public void updateInfo(SNMPTableRowMO moInst) {
        this.setBean(moInst);
        this.fillUI();
    }

    @Override
    public void fillUI() {
        if (this.enabled) {
            for (Binding binding : this.bindings) {
                binding.fillUIComponent();
            }
        }
    }

    @Override
    public void fillUIFromBean(Object newBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean fillBeanFromUI(Object newBean) {
        throw new UnsupportedOperationException();
    }

    public void setBean(SNMPTableRowMO moInst) {
        this.moInst = moInst;
    }
}

