/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.model.Validatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIValidator {
    private static final ResourceBundle bundle = Internationalizer.getInternationalizer("com.bwanms.validator").asBundle();

    public static void validate(List<InvalidValue> invalidValues, Binder binder) {
        binder.configureBean(invalidValues);
        if (binder.isEnabled()) {
            Object bean = binder.getBean();
            ArrayList<InvalidValue> invalidValues2 = new ArrayList<InvalidValue>(Arrays.asList(new ClassValidator(bean.getClass(), bundle).getInvalidValues(bean)));
            if (bean instanceof Validatable) {
                ((Validatable)bean).validate(invalidValues2);
            }
            ArrayList<Object> filteredInvalidValues = null;
            if (bean.getClass().getAnnotation(AlwaysValidate.class) != null) {
                filteredInvalidValues = invalidValues2;
            } else {
                filteredInvalidValues = new ArrayList();
                binder.filterInvalidValuesPerBinder(filteredInvalidValues, invalidValues2);
            }
            binder.toUIInvalidValues(invalidValues, filteredInvalidValues);
        }
    }

    public static void validate(List<InvalidValue> invalidValues, Object bean) {
        invalidValues.addAll(Arrays.asList(new ClassValidator(bean.getClass(), bundle).getInvalidValues(bean)));
        if (bean instanceof Validatable) {
            ((Validatable)bean).validate(invalidValues);
        }
    }
}

