/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.AbstractBinding;
import com.bwanms.gui.binding.ReadOnlyBinding;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.OctetString;
import com.bwanms.validation.UIInvalidValue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIBinding<C extends JComponent, P>
extends AbstractBinding
implements ReadOnlyBinding {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(UIBinding.class);
    private static final Logger log = Logger.getLogger(UIBinding.class);
    private boolean readOnly = false;
    private final String errorMessage;

    public UIBinding(String uiBeanProperty, String beanProperty, String propertyName) {
        super(uiBeanProperty, beanProperty, propertyName);
        this.errorMessage = null;
    }

    public UIBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator, String propertyName) {
        super(uiBeanProperty, beanProperty, translator, propertyName);
        this.errorMessage = null;
    }

    public UIBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator, String propertyName, String errorMessage) {
        super(uiBeanProperty, beanProperty, translator, propertyName);
        this.errorMessage = errorMessage;
    }

    public UIBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator, JLabel label) {
        super(uiBeanProperty, beanProperty, translator, label);
        this.errorMessage = null;
    }

    @Deprecated
    public UIBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator) {
        super(uiBeanProperty, beanProperty, translator);
        this.errorMessage = null;
    }

    @Deprecated
    public UIBinding(String uiBeanProperty, String beanProperty) {
        super(uiBeanProperty, beanProperty);
        this.errorMessage = null;
    }

    protected final C getUIComponent() {
        return (C)((JComponent)BeanUtils.getPropertyValue(this.getBinder().getUiBean(), this.getUiBeanProperty()));
    }

    @Override
    public void initUI() {
        super.initUI();
        Method method = BeanUtils.getGetter(this.getBeanClass(), this.getBeanProperty());
        try {
            this.initUI(method);
        }
        catch (Throwable e) {
            log.error((Object)"initUI()", e);
        }
    }

    protected Class getBeanClass() {
        return this.getBinder().getBean().getClass();
    }

    @Override
    protected Object getUIValue() {
        return this.getUIComponentValue();
    }

    @Override
    protected void setUIValue(Object value) {
        C uiComponent = this.getUIComponent();
        Object convertedValue = null;
        try {
            convertedValue = this.getTranslator().convertToUIValue(value);
            this.setUIComponentValue(convertedValue);
        }
        catch (Exception e) {
            throw new RuntimeException("For bean [" + uiComponent + "] can't setProperty [" + this.getUiBeanProperty() + "] to value [" + convertedValue + "]", e);
        }
    }

    protected Object findAnnotation(AnnotatedElement annotatedElement, Class name) {
        Object values = annotatedElement.getAnnotation(name);
        if (values == null) {
            Class<?> a = Proxy.getProxyClass(this.getClass().getClassLoader(), name);
            values = annotatedElement.getAnnotation(a);
        }
        return values;
    }

    protected abstract P getUIComponentValue();

    protected abstract void setUIComponentValue(P var1);

    protected void initUI(AnnotatedElement annotatedElement) {
        ((JComponent)this.getUIComponent()).setEnabled(!this.readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    protected UIInvalidValue createUIInvalidValue(Object value, Object bean, Exception e) {
        if (null != this.getLabel()) {
            this.setPropertyName(this.getLabel().getText());
        }
        log.debug((Object)"", (Throwable)e);
        String ivErrorMessage = null;
        if (this.errorMessage == null) {
            ivErrorMessage = e instanceof OctetString.RangeNumberFormatException ? i18n.translateString("InvalidValueRange", ((OctetString.RangeNumberFormatException)e).rangeStart, ((OctetString.RangeNumberFormatException)e).rangeEnd) : i18n.translateString("InvalidValue", value);
        }
        return new UIInvalidValue(null, "bean[" + this.getUIComponent().getClass() + "]", this.getUIComponent().getClass(), null == this.getPropertyName() ? this.getUiBeanProperty() : this.getPropertyName(), value, this.getUIComponent(), this.errorMessage != null ? this.errorMessage : ivErrorMessage, new Object[0]);
    }

    @Override
    protected UIInvalidValue toUIInvalidValue(InvalidValue invalidValue) {
        if (null != this.getLabel()) {
            this.setPropertyName(this.getLabel().getText());
        }
        UIInvalidValue result = new UIInvalidValue(invalidValue, "bean", this.getUIComponent().getClass(), null == this.getPropertyName() ? this.getUiBeanProperty() : this.getPropertyName(), invalidValue.getValue(), this.getUIComponent(), invalidValue.getMessage(), new Object[0]);
        return result;
    }
}

