/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.translators.NullTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.mo.AbstractTableMO;
import com.bwanms.util.BeanUtils;
import com.bwanms.validation.UIInvalidValue;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnBinding
implements Binding<TableBinder> {
    private static final Logger logger = Logger.getLogger(TableColumnBinding.class);
    private String beanEntryProperty;
    private int currentRowIndex;
    private TableBinder binder;
    private String uiColumnName;
    private Object currentEntry;
    private Integer columnIndex;
    private ValueTranslator translator;

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public void setCurrentEntry(Object currentEntry) {
        this.currentEntry = currentEntry;
    }

    public TableColumnBinding(String uiColumnName, String beanEntryProperty) {
        this(uiColumnName, beanEntryProperty, new NullTranslator());
    }

    public TableColumnBinding(String uiColumnName, String beanEntryProperty, ValueTranslator translator) {
        this.beanEntryProperty = beanEntryProperty;
        this.uiColumnName = uiColumnName;
        this.translator = translator;
    }

    @Override
    public void initUI() {
    }

    @Override
    public void fillUIComponent() {
        try {
            this.binder.getTableModel().setInitialValueAt(this.translator.convertToUIValue(this.getBeanValue()), this.currentRowIndex, this.getColumnIndex());
        }
        catch (TranslateException e) {
            logger.error((Object)"Can't translate.", (Throwable)e);
        }
    }

    private Object getBeanValue() {
        return BeanUtils.getPropertyValue(this.currentEntry, this.beanEntryProperty);
    }

    private int getColumnIndex() {
        if (this.columnIndex == null) {
            String translatedColumnName = this.getTranslatedColumnName(this.uiColumnName);
            this.columnIndex = this.binder.getTableModel().findColumn(translatedColumnName);
            if (this.columnIndex == -1) {
                throw new RuntimeException("Can't find a column for name [" + translatedColumnName + "] for table [" + this.binder.getTableModel() + "]");
            }
        }
        return this.columnIndex;
    }

    private String getTranslatedColumnName(String columnName) {
        return this.binder.getI18n().translateString(columnName);
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
    }

    @Override
    public void setBinder(TableBinder binder) {
        this.binder = binder;
    }

    @Override
    public void toUIInvalidValues(List<InvalidValue> uiInvalidValues, List<InvalidValue> invalidValues) {
        for (InvalidValue invalidValue : invalidValues) {
            if (!this.accept(invalidValue.getBean(), invalidValue.getPropertyName())) continue;
            uiInvalidValues.add(this.toUIInvalidValue(invalidValue));
        }
    }

    private boolean accept(Object bean, String propertyName) {
        return propertyName.equals(this.beanEntryProperty) && ((AbstractTableMO)this.binder.getBean()).getEntries().contains(bean);
    }

    protected UIInvalidValue toUIInvalidValue(InvalidValue invalidValue) {
        String propertyName = this.getTranslatedColumnName(this.uiColumnName);
        if (null == propertyName) {
            propertyName = this.uiColumnName;
        }
        return new UIInvalidValue(invalidValue, "bean", this.binder.getUiBean().getClass(), propertyName, invalidValue.getValue(), this.binder.getUiBean(), invalidValue.getMessage(), new Object[0]);
    }

    @Override
    public String getBeanProperty() {
        return this.beanEntryProperty;
    }
}

