/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.UIBinding;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.validation.Values;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JComboBoxBinding
extends UIBinding<JComboBox, Object> {
    private Internationalizer i18n;
    private Object nullValue = null;
    private boolean ignoreDisabled = false;
    private static Internationalizer localI18n = Internationalizer.getInternationalizer(JComboBoxBinding.class);

    public JComboBoxBinding(Internationalizer i18n, String uiBeanProperty, String beanProperty, String propertyName) {
        super(uiBeanProperty, beanProperty, propertyName);
        this.i18n = i18n;
    }

    public JComboBoxBinding(Internationalizer i18n, String uiBeanProperty, String beanProperty, ValueTranslator translator, String propertyName) {
        super(uiBeanProperty, beanProperty, translator, propertyName);
        this.i18n = i18n;
    }

    public JComboBoxBinding(String uiBeanProperty, String beanProperty, String propertyName) {
        super(uiBeanProperty, beanProperty, propertyName);
    }

    public JComboBoxBinding(Internationalizer i18n, String uiBeanProperty, String beanProperty, Object nullValue, String propertyName) {
        super(uiBeanProperty, beanProperty, propertyName);
        this.i18n = i18n;
        this.nullValue = nullValue;
    }

    public JComboBoxBinding(String uiBeanProperty, String beanProperty, Object nullValue, String propertyName) {
        super(uiBeanProperty, beanProperty, propertyName);
        this.nullValue = nullValue;
    }

    @Deprecated
    public JComboBoxBinding(Internationalizer i18n, String uiBeanProperty, String beanProperty) {
        super(uiBeanProperty, beanProperty);
        this.i18n = i18n;
    }

    @Deprecated
    public JComboBoxBinding(String uiBeanProperty, String beanProperty) {
        super(uiBeanProperty, beanProperty);
    }

    @Deprecated
    public JComboBoxBinding(Internationalizer i18n, String uiBeanProperty, String beanProperty, Object nullValue) {
        super(uiBeanProperty, beanProperty);
        this.i18n = i18n;
        this.nullValue = nullValue;
    }

    @Deprecated
    public JComboBoxBinding(String uiBeanProperty, String beanProperty, Object nullValue) {
        super(uiBeanProperty, beanProperty);
        this.nullValue = nullValue;
    }

    @Override
    protected Object getUIComponentValue() {
        if (((JComboBox)this.getUIComponent()).isEnabled() || this.ignoreDisabled) {
            if (((JComboBox)this.getUIComponent()).getSelectedItem() == null) {
                return this.nullValue;
            }
            return ((ComboItem)((JComboBox)this.getUIComponent()).getSelectedItem()).getValue();
        }
        return this.nullValue;
    }

    @Override
    protected void setUIComponentValue(Object value) {
        JComboBox combo = (JComboBox)this.getUIComponent();
        if (combo.getItemCount() > 0 && ((ComboItem)combo.getItemAt(0)).isInvalidItem()) {
            combo.removeItemAt(0);
        }
        if (value == null) {
            if (combo.getItemCount() > 0) {
                combo.setSelectedIndex(0);
            }
            return;
        }
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!((ComboItem)combo.getItemAt(i)).getValue().toString().equals(value.toString())) continue;
            combo.setSelectedIndex(i);
            return;
        }
        ComboItem invalidComboItem = new ComboItem(value, localI18n.translateString("Unknown", value));
        invalidComboItem.setInvalidItem(true);
        combo.insertItemAt(invalidComboItem, 0);
        combo.setSelectedIndex(0);
    }

    @Override
    protected void initUI(AnnotatedElement annotatedElement) {
        ((JComboBox)this.getUIComponent()).setEnabled(!this.isReadOnly());
        try {
            Values values = (Values)this.findAnnotation(annotatedElement, Values.class);
            if (values == null) {
                return;
            }
            Method convertor = this.getBeanClass().getMethod(values.toStringConvertorMethodName(), Integer.class);
            ((JComboBox)this.getUIComponent()).removeAllItems();
            for (int value : values.values()) {
                Integer dataValue = new Integer(value);
                String textValue = (String)convertor.invoke(null, dataValue);
                if (this.i18n != null) {
                    ((JComboBox)this.getUIComponent()).addItem(new ComboItem(dataValue, this.i18n.translateString(textValue)));
                    continue;
                }
                ((JComboBox)this.getUIComponent()).addItem(new ComboItem(dataValue, textValue));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setIgnoreDisabled(boolean ignoreDisabled) {
        this.ignoreDisabled = ignoreDisabled;
    }
}

