/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.BindingCallback;
import com.bwanms.gui.binding.UIValidator;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingManager {
    List<Binder> binders;
    private BindingCallback callback;
    private List<InvalidValue> invalidValues;

    public BindingManager(List<Binder> binders) {
        this(binders, null);
    }

    public BindingManager(List<Binder> binders, BindingCallback callback) {
        this.binders = binders;
        this.callback = callback;
        this.invalidValues = new ArrayList<InvalidValue>();
        if (this.callback != null) {
            this.callback.setBinders(binders);
        }
    }

    public void fillUI() {
        for (Binder binder : this.binders) {
            binder.fillUI();
        }
        if (this.callback != null) {
            this.callback.fillUI();
        }
    }

    public void configAndValidate() {
        this.invalidValues.clear();
        for (Binder binder : this.binders) {
            UIValidator.validate(this.invalidValues, binder);
        }
        if (this.callback != null) {
            this.callback.configureAndValidate(this.invalidValues);
        }
    }

    public boolean hasErrors() {
        return !this.invalidValues.isEmpty();
    }

    public List<InvalidValue> getInvalidValues() {
        return this.invalidValues;
    }

    public List<Binder> getBinders() {
        return this.binders;
    }

    public void setBinders(List<Binder> binders) {
        this.binders = binders;
    }
}

