/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.translators.NullTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.util.BeanUtils;
import com.bwanms.validation.UIInvalidValue;
import java.util.List;
import javax.swing.JLabel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinding<TheBinder extends Binder>
implements Binding<TheBinder> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AbstractBinding.class);
    private String uiBeanProperty;
    private String beanProperty;
    private String propertyName = null;
    private JLabel label = null;
    private TheBinder binder;
    private ValueTranslator<Object, Object> translator;

    public AbstractBinding(String uiBeanProperty, String beanProperty, String propertyName) {
        this(uiBeanProperty, beanProperty, (ValueTranslator)new NullTranslator(), propertyName);
    }

    public AbstractBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator, String propertyName) {
        this.uiBeanProperty = uiBeanProperty;
        this.beanProperty = beanProperty;
        this.translator = translator;
        this.propertyName = propertyName;
    }

    public AbstractBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator, JLabel label) {
        this.uiBeanProperty = uiBeanProperty;
        this.beanProperty = beanProperty;
        this.translator = translator;
        this.label = label;
    }

    @Deprecated
    public AbstractBinding(String uiBeanProperty, String beanProperty) {
        this(uiBeanProperty, beanProperty, new NullTranslator());
    }

    @Deprecated
    public AbstractBinding(String uiBeanProperty, String beanProperty, ValueTranslator translator) {
        this.uiBeanProperty = uiBeanProperty;
        this.beanProperty = beanProperty;
        this.translator = translator;
    }

    @Override
    public void setBinder(TheBinder binder) {
        this.binder = binder;
    }

    @Override
    public void initUI() {
    }

    @Override
    public void fillUIComponent() {
        this.setUIValue(this.getBeanValue());
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
        this.setBeanValue(this.getUIValue(), invalidValues);
    }

    @Override
    public void toUIInvalidValues(List<InvalidValue> uiInvalidValues, List<InvalidValue> invalidValues) {
        for (InvalidValue invalidValue : invalidValues) {
            if (!this.accept(invalidValue.getBean(), invalidValue.getPropertyName())) continue;
            uiInvalidValues.add(this.toUIInvalidValue(invalidValue));
        }
    }

    protected UIInvalidValue toUIInvalidValue(InvalidValue invalidValue) {
        if (null != this.label) {
            this.propertyName = this.label.getText();
        }
        return new UIInvalidValue(invalidValue, "bean", this.binder.getUiBean().getClass(), this.propertyName == null ? this.uiBeanProperty : this.propertyName, invalidValue.getValue(), this.binder.getUiBean(), invalidValue.getMessage(), new Object[0]);
    }

    private boolean accept(Object bean, String propertyName) {
        return propertyName.equals(this.beanProperty) && bean.equals(this.binder.getBean());
    }

    @Override
    public String getBeanProperty() {
        return this.beanProperty;
    }

    protected Binder getBinder() {
        return this.binder;
    }

    protected ValueTranslator<Object, Object> getTranslator() {
        return this.translator;
    }

    protected String getUiBeanProperty() {
        return this.uiBeanProperty;
    }

    private Object getBeanValue() {
        return BeanUtils.getPropertyValue(this.getBinder().getBean(), this.getBeanProperty());
    }

    private void setBeanValue(Object value, List<InvalidValue> invalidValues) {
        Object bean = this.getBinder().getBean();
        Object convertedValue = null;
        try {
            convertedValue = this.getTranslator().convertToBeanValue(value);
        }
        catch (TranslateException e) {
            invalidValues.add(this.createUIInvalidValue(value, bean, e));
            return;
        }
        catch (Exception e) {
            String errorMessage = "Can't convertToBeanValue [" + value + "]";
            if (this.translator != null) {
                errorMessage = errorMessage + " using " + this.translator.getClass().getName();
            }
            throw new RuntimeException(errorMessage, e);
        }
        try {
            BeanUtils.setPropertyValue(bean, this.getBeanProperty(), convertedValue);
        }
        catch (Exception e) {
            throw new RuntimeException("For bean [" + bean + "] can't setProperty [" + this.getBeanProperty() + "] to value [" + convertedValue + "]", e);
        }
    }

    protected UIInvalidValue createUIInvalidValue(Object value, Object bean, Exception e) {
        if (null != this.label) {
            this.propertyName = this.label.getText();
        }
        return new UIInvalidValue(null, "bean[" + bean.getClass() + "]", this.binder.getUiBean().getClass(), this.propertyName == null ? this.getUiBeanProperty() : this.propertyName, value, this.binder.getUiBean(), i18n.translateString("InvalidValue", value), new Object[0]);
    }

    protected String getBeanSetterType() {
        return BeanUtils.getSetter(this.getBinder().getBean().getClass(), this.getBeanProperty()).getParameterTypes()[0].getName();
    }

    protected abstract Object getUIValue();

    protected abstract void setUIValue(Object var1);

    public String getPropertyName() {
        return this.propertyName;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }
}

