/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.binding;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.validation.UIInvalidValue;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinder<TheBinding extends Binding>
implements Binder<TheBinding> {
    protected List<TheBinding> bindings;
    protected Object uiBean;
    protected Object bean;
    protected boolean enabled;

    public AbstractBinder(Object uiBean, Object bean) {
        if (uiBean == null || bean == null) {
            throw new NullPointerException("Cannot use Binder with null values");
        }
        this.bindings = new ArrayList<TheBinding>();
        this.uiBean = uiBean;
        this.bean = bean;
        this.enabled = true;
    }

    @Override
    public Binder<TheBinding> add(TheBinding binding) {
        this.bindings.add(binding);
        binding.setBinder((AbstractBinder)this);
        return this;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public Object getUiBean() {
        return this.uiBean;
    }

    @Override
    public void initUI() {
        for (Binding binding : this.bindings) {
            binding.initUI();
        }
    }

    @Override
    public void fillUI() {
        for (Binding binding : this.bindings) {
            binding.fillUIComponent();
        }
    }

    @Override
    public void configureBean(List<InvalidValue> invalidValues) {
        if (this.enabled) {
            for (Binding binding : this.bindings) {
                binding.configureBean(invalidValues);
            }
        }
    }

    @Override
    public void toUIInvalidValues(List<InvalidValue> uiInvalidValues, List<InvalidValue> invalidValues) {
        this.createNewUIInvalidValues(uiInvalidValues, invalidValues);
        for (InvalidValue invalidValue : invalidValues) {
            if (this.isConsumed(uiInvalidValues, invalidValue)) continue;
            uiInvalidValues.add(invalidValue);
        }
    }

    private boolean isConsumed(List<InvalidValue> uiInvalidValues, InvalidValue invalidValue) {
        for (InvalidValue uiInvalidValue : uiInvalidValues) {
            UIInvalidValue uiInvalidValue2;
            if (!(uiInvalidValue instanceof UIInvalidValue) || !invalidValue.equals((uiInvalidValue2 = (UIInvalidValue)uiInvalidValue).getCauseInvalidValue())) continue;
            return true;
        }
        return false;
    }

    private void createNewUIInvalidValues(List<InvalidValue> uiInvalidValues, List<InvalidValue> invalidValues) {
        for (Binding binding : this.bindings) {
            binding.toUIInvalidValues(uiInvalidValues, invalidValues);
        }
    }

    protected List<TheBinding> getBindings() {
        return this.bindings;
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void fillUIFromBean(Object newBean) {
        Object bean = this.getBean();
        this.setBean(newBean);
        this.fillUI();
        this.setBean(bean);
    }

    public boolean fillBeanFromUI(Object newBean) {
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        Object bean = this.getBean();
        this.setBean(newBean);
        this.configureBean(iValues);
        this.setBean(bean);
        return iValues.isEmpty();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void filterInvalidValuesPerBinder(List<InvalidValue> filteredInvalidValues, List<InvalidValue> invalidValues) {
        for (Binding binding : this.bindings) {
            for (InvalidValue invalidValue : invalidValues) {
                if (!binding.getBeanProperty().equals(invalidValue.getPropertyName())) continue;
                filteredInvalidValues.add(invalidValue);
            }
        }
    }
}

