/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.auditlogmanager;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.auditlogmanager.AuditLogPluginUtil;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.AuditLogEntry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TaskPluginUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditLogManagerConfig
extends EntityManagerConfig {
    public static final Internationalizer i18n = AuditLogPluginUtil.getInternationalizer();
    private static final Logger logger = Logger.getLogger(AuditLogManagerConfig.class);
    private static final String[] columnNames = new String[]{"EventTime", "Category", "UserID", "Action", "TargetEntity", "EntityType"};
    private static final String[] columnAttribNames = new String[]{"EventTime", "Category", "UserId", "Action", "TargetEntity", "EntityType"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public static String[] getColumnAttribNames() {
        return columnAttribNames;
    }

    public static String[] getColumnNames() {
        return columnNames;
    }

    public AuditLogManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(columnNames[5], columnAttribNames[5], i18n.translateString(columnNames[5]), new EntityManagerRowDisplayComparator(5)));
        this.entityRowProvider = new AuditLogRowCreator(AuditLogManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        List<String> categoriesList = AuditLogPluginUtil.getRegisteredCategories();
        Vector<Object> items = new Vector<Object>(categoriesList.size());
        for (String s : categoriesList) {
            items.add(new ComboItem(s, i18n.translateString(s)));
        }
        items = this.sortComboItems(items);
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Category"), "category", 2, 3, items, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("UserID"), "userId", 1, 1, null, false));
        List<String> actionsList = AuditLogPluginUtil.getRegisteredActions();
        items = new Vector(actionsList.size());
        for (String s : actionsList) {
            items.add(new ComboItem(s, i18n.translateString(s)));
        }
        items = this.sortComboItems(items);
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Action"), "action", 2, 3, items, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("TargetEntity"), "targetEntity", 1, 1, null, false));
        List<Class> taskTypesList = TaskPluginUtil.getTaskTypesList();
        items = new Vector(taskTypesList.size());
        for (Class s : taskTypesList) {
            items.add(new ComboItem(s.getName(), i18n.translateString(s.getName())));
        }
        List<String> entityTypeList = AuditLogPluginUtil.getRegisteredEntityTypes();
        for (String s : entityTypeList) {
            items.add(new ComboItem(s, i18n.translateString(s)));
        }
        items = this.sortComboItems(items);
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("EntityType"), "entityType", 2, 3, items, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new AuditLogManagerAction("Export", 1);
        this.declaredActions.add(this.defaultAction);
    }

    @Override
    protected String getBaseName() {
        return AuditLogEntry.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("AuditLogManager");
    }

    @Override
    public String getHelpTopic() {
        return "redcell.auditTrail_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AuditLogRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -4610259142332274357L;

        AuditLogRowCreator(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            AuditLogEntry auditLogEntry = (AuditLogEntry)entityRow.getEntity();
            if (auditLogEntry.getEventTime() > 0L) {
                Calendar time = Calendar.getInstance();
                time.setTimeInMillis(auditLogEntry.getEventTime());
                ret.set(0, DateFormatter.format(time.getTime()));
            } else {
                ret.set(0, "");
            }
            ret.set(1, i18n.translateString(auditLogEntry.getCategory()));
            ret.set(3, i18n.translateString(auditLogEntry.getAction()));
            ret.set(5, i18n.translateString(auditLogEntry.getEntityType()));
            return ret;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((AuditLogEntry)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuditLogManagerAction
    extends ManagerAction {
        public AuditLogManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public void performAction(ManagerView manager) {
            File exportFile;
            List<Serializable> selection = manager.getSelection();
            if ("Export".equals(this.name) && (exportFile = this.getExportFile("csv", manager.getUI())) != null) {
                boolean overwriteExistingFile = false;
                if (exportFile.exists() && !(overwriteExistingFile = MessageBox.WarnConfirm.showResult(manager.getUI(), i18n.translateString("ExportFileReplacingConfirmation", exportFile.getAbsolutePath()), i18n.translateString("ExportLogTitle")))) {
                    logger.info((Object)i18n.translateString("ExportFileReplacingRejected", exportFile.getAbsolutePath()));
                    return;
                }
                try {
                    this.exportAuditLogs(((EntityManagerView)manager).getSelectionData(), exportFile);
                    logger.info((Object)i18n.translateString("AuditLogsExported", selection.size(), exportFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    logger.debug((Object)"Export audit logs error", (Throwable)e);
                    MessageBox.Error.showResult(manager.getUI(), i18n.translateString("AuditLogsExported", e.getMessage()), i18n.translateString("ExportLogTitle"));
                }
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            return this.name.equals("Export") && selection.size() > 0;
        }

        private File getExportFile(String fileExt, JComponent uiParent) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(i18n.translateString("ExportLogTitle"));
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setApproveButtonText(i18n.translateString("FileChooserApproveButton"));
            fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserApproveButtonToolTip"));
            ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
            fileExtFilter.addExtension(fileExt);
            fileExtFilter.setDescription(i18n.translateString("ExportAuditLogFilterDescr", "*." + fileExt));
            fileChooser.setFileFilter(fileExtFilter);
            int ret = fileChooser.showOpenDialog(uiParent);
            if (ret == 0) {
                String ext;
                File exportFile = fileChooser.getSelectedFile();
                int lastDotIndex = exportFile.getName().lastIndexOf(46);
                String string = ext = lastDotIndex == -1 ? null : exportFile.getName().substring(lastDotIndex + 1);
                if (!fileExt.equalsIgnoreCase(ext)) {
                    exportFile = new File(exportFile.getAbsolutePath() + "." + fileExt);
                }
                return exportFile;
            }
            return null;
        }

        private void exportAuditLogs(List<EntityManagerRow> selectedRows, File selectedFile) throws IOException {
            if (selectedRows == null || selectedRows.size() == 0 || selectedFile == null) {
                return;
            }
            if (!selectedFile.exists()) {
                selectedFile.createNewFile();
            }
            CSVWriter csvOut = new CSVWriter((Writer)new FileWriter(selectedFile));
            csvOut.writeNext(AuditLogManagerConfig.this.getColumnTitles());
            for (EntityManagerRow row : selectedRows) {
                csvOut.writeNext(row.getDisplayValues().toArray(new String[0]));
            }
            csvOut.close();
        }
    }
}

