/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui.about;

import com.bwanms.client.properties.PropertiesManagerClient;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.about.AboutForm;
import com.bwanms.platform.PlatformRuntime;
import com.bwanms.plugin.IPluginDefinition;
import com.bwanms.setup.clientupdater.ClientUpdater;
import com.bwanms.util.InstallInfoUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.version.impl.DefaultVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;

public class AboutView
implements View {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(AboutView.class);
    protected AboutForm form;
    protected StringBuffer forPrint = new StringBuffer();

    public AboutView() {
        this.configure();
    }

    private void configure() {
        block26: {
            block24: {
                List<IPluginDefinition> serverList;
                block25: {
                    block23: {
                        String shortMsg;
                        if (!this.isEnterprise()) break block24;
                        try {
                            PropertiesManagerClient.getInstance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageBox.Error.quickShow(this.getUI(), i18n.translateString("VersionMismatch"));
                            System.exit(1);
                        }
                        boolean inconsistency = false;
                        String serverPrefix = i18n.translateString("PrefixServer") + " ";
                        String clientPrefix = i18n.translateString("PrefixClient") + " ";
                        IPluginDefinition serverInfo = InstallInfoUtil.getCachedServerInfrInfo();
                        IPluginDefinition clientInfo = InstallInfoUtil.getCachedClientInfrInfo();
                        inconsistency = !serverInfo.getVersion().equalsIgnoreCase(clientInfo.getVersion());
                        this.forPrint.append(this.formatPluginInfo(serverInfo, serverPrefix));
                        this.forPrint.append(this.formatPluginInfo(clientInfo, clientPrefix));
                        if (inconsistency) {
                            String serverIP = "";
                            String serverPort = "";
                            try {
                                Properties props = new Properties();
                                FileInputStream is = new FileInputStream(ClientUpdater.FILE_PROPS);
                                props.load(is);
                                ((InputStream)is).close();
                                serverIP = props.getProperty(ClientUpdater.ClientUpdaterInputProps.P_IP.getPropertyName());
                                serverPort = props.getProperty(ClientUpdater.ClientUpdaterInputProps.P_PORT.getPropertyName());
                                is = new FileInputStream(ClientUpdater.FILE_OWAPPSERVER_PROPS);
                                props.load(is);
                                ((InputStream)is).close();
                                try {
                                    String serverUrl = props.getProperty(ClientUpdater.ClientUpdaterInputProps.P_OWAPPSERVER_URL.getPropertyName());
                                    serverIP = serverUrl.replaceAll("jnp://", "").replaceAll(":3100", "");
                                }
                                catch (Exception e) {}
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            shortMsg = i18n.translateString("InstallInconsistencyUninstall", String.format("http://%s:%s/bwanms", serverIP, serverPort) + "/client");
                            MessageBox.details(this.getUI(), i18n.translateString("InstallInconsistencyTitle"), shortMsg, this.forPrint.toString().replaceAll("\r\n", "<br />"));
                            System.exit(0);
                        }
                        serverList = InstallInfoUtil.getCachedServerDDInfoList();
                        List<IPluginDefinition> clientList = InstallInfoUtil.getCachedClientDDInfoList();
                        Comparator<IPluginDefinition> cmp = InstallInfoUtil.getComparator();
                        int si = 0;
                        int ci = 0;
                        block12: while (si < serverList.size() && ci < clientList.size()) {
                            serverInfo = serverList.get(si);
                            clientInfo = clientList.get(ci);
                            switch (cmp.compare(serverInfo, clientInfo)) {
                                case 0: {
                                    DefaultVersion oldVersion = new DefaultVersion(clientInfo.getVersion());
                                    DefaultVersion newVersion = new DefaultVersion(serverInfo.getVersion());
                                    if (oldVersion.isEqualWith(newVersion)) {
                                        this.forPrint.append(this.formatPluginInfo(serverInfo, serverPrefix));
                                        this.forPrint.append(this.formatPluginInfo(serverInfo, clientPrefix));
                                    } else if (oldVersion.isNewerThan(newVersion)) {
                                        inconsistency = true;
                                        this.forPrint.append(this.formatPluginInfo(serverInfo, serverPrefix));
                                        this.forPrint.append(this.formatPluginInfo(clientInfo, clientPrefix));
                                    } else {
                                        inconsistency = true;
                                        this.forPrint.append(this.formatPluginInfo(serverInfo, serverPrefix));
                                        this.forPrint.append(this.formatPluginInfo(clientInfo, clientPrefix));
                                    }
                                    ++si;
                                    ++ci;
                                    continue block12;
                                }
                                case 1: {
                                    ++ci;
                                    inconsistency = true;
                                    this.forPrint.append(this.formatPluginInfo(clientInfo, clientPrefix));
                                    continue block12;
                                }
                            }
                            ++si;
                            inconsistency = true;
                            this.forPrint.append(this.formatPluginInfo(serverInfo, serverPrefix));
                        }
                        if (si < serverList.size()) {
                            serverInfo = serverList.get(si++);
                            this.forPrint.append(this.formatPluginInfo(serverInfo, serverPrefix));
                            inconsistency = true;
                        }
                        while (ci < clientList.size()) {
                            clientInfo = clientList.get(ci++);
                            this.forPrint.append(this.formatPluginInfo(clientInfo, clientPrefix));
                            inconsistency = true;
                        }
                        if (!inconsistency) break block25;
                        shortMsg = i18n.translateString("InstallInconsistencyUpdate");
                        StringBuffer cmd = new StringBuffer("\"-cp\" \"bwanms.jar;log4j-1.2.11.jar;forms-1.0.5.jar;ngnms-resources.jar;looks-1.3.1.jar;\" \"com.bwanms.setup.clientupdater.ClientUpdater\"");
                        MessageBox.details(this.getUI(), i18n.translateString("InstallInconsistencyTitle"), shortMsg, this.forPrint.toString().replaceAll("\r\n", "<br />"));
                        try {
                            this.createClientUpdaterIniFile(serverList, clientList);
                            PlatformRuntime.OS os = PlatformRuntime.getOS();
                            Logger logger = Logger.getLogger(AboutView.class);
                            if (os.getID() == PlatformRuntime.OS.WINDOWS.getID()) {
                                String fullCmd = "start \"Updater\" \"" + System.getProperty("java.home") + "/bin/javaw\" " + cmd.toString();
                                logger.info((Object)("run updater: " + fullCmd));
                                os.runShellCmd(fullCmd, InstallInfoUtil.PATH_OWAREAPPS + "/ngnms/lib");
                                break block23;
                            }
                            if (os.getID() == PlatformRuntime.OS.SOLARIS.getID()) {
                                String fullCmd = "\"" + System.getProperty("java.home") + "/bin/java\" " + cmd.toString() + " &";
                                logger.info((Object)("run updater: " + fullCmd));
                                os.runShellCmd(fullCmd, InstallInfoUtil.PATH_OWAREAPPS + "/ngnms/lib");
                                break block23;
                            }
                            throw new RuntimeException("Unknown operating system - cannot run updater");
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Run updater failed!", e);
                        }
                    }
                    System.exit(0);
                    break block26;
                }
                if (serverList.size() > 0) break block26;
                MessageBox.Error.quickShow(this.getUI(), i18n.translateString("InstallInconsistencyNoDD"));
                System.exit(0);
                break block26;
            }
            this.forPrint.append(this.formatPluginInfo(InstallInfoUtil.getCachedServerInfrInfo()));
            for (IPluginDefinition plugin : InstallInfoUtil.getCachedServerDDInfoList()) {
                this.forPrint.append(this.formatPluginInfo(plugin));
            }
        }
    }

    private void createClientUpdaterIniFile(List serverList, List clientList) throws Exception {
        File propDir = new File(ClientUpdater.FILE_INIT_DIR);
        if (!propDir.isDirectory() && !propDir.mkdir()) {
            throw new Exception("cant create dir for updater properties file");
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(ClientUpdater.FILE_INIT));
        oos.writeObject(serverList);
        oos.writeObject(clientList);
        oos.close();
    }

    private boolean isEnterprise() {
        String platform = System.getProperty("com.bwanms.platform", "remote");
        return !"local".equalsIgnoreCase(platform) && !"debug".equalsIgnoreCase(platform);
    }

    private String formatPluginInfo(IPluginDefinition plugin) {
        return this.formatPluginInfo(plugin, "");
    }

    private String formatPluginInfo(IPluginDefinition plugin, String prefix) {
        StringBuffer buffer = new StringBuffer();
        String pluginName = plugin.getNameTranslated();
        String pluginVersion = plugin.getVersion();
        String pluginInfo = plugin.getInfo();
        buffer.append(prefix);
        buffer.append(pluginName).append("  -  ").append(pluginVersion);
        if (pluginInfo != null && pluginInfo.length() > 0) {
            buffer.append(" ").append(i18n.translateString("SupportedVersions")).append(" ").append(pluginInfo);
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    public JComponent getUI() {
        if (this.form == null) {
            this.initForm();
            JTextPane textPanel = this.form.getTextPanel();
            textPanel.setText(this.forPrint.toString());
        }
        return this.form;
    }

    protected void initForm() {
        this.form = new AboutForm();
    }

    public void cleanup() {
    }

    public String getTitle() {
        return i18n.translateString("AboutFormTitle");
    }

    public boolean close() {
        return true;
    }
}

