/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.UIIconFactories;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class UIIconFactory {
    private static final Logger logger = Logger.getLogger(UIIconFactory.class);
    public static final int FLAG_PLAIN = 0;
    public static final int FLAG_GRAYED = 1;
    public static final int FLAG_DECORATED = 2;
    public static final int SIZE_16x16 = 16;
    public static final int SIZE_32x32 = 32;

    public abstract Icon getIconImpl(Object var1, int var2);

    public abstract Icon getIconForClassImpl(Class var1);

    public static final Icon getIcon(Object target, int flags) {
        UIIconFactory factory = UIIconFactories.instance().getUIIconFactory(target);
        if (factory == null) {
            logger.debug((Object)("No Icon Factory found for: " + (target == null ? "null" : target.getClass().getName())));
            return null;
        }
        return factory.getIconImpl(target, flags);
    }

    public static final Icon getIconForClass(Class clazz) {
        UIIconFactory factory = UIIconFactories.instance().getUIIconFactoryForClass(clazz);
        if (factory == null) {
            logger.debug((Object)("No Icon Factory found for: " + clazz.getName()));
            return null;
        }
        return factory.getIconForClassImpl(clazz);
    }

    public static final Icon getIconForClass(String clazzName) {
        try {
            return UIIconFactory.getIconForClass(Class.forName(clazzName));
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            return null;
        }
    }
}

