/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.UIIconFactory;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.CachedClassMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

class UIIconFactories {
    private static final Logger logger = Logger.getLogger(UIIconFactories.class);
    private CachedClassMap<UIIconFactory> factories;
    private static UIIconFactories singleton;

    public static UIIconFactories instance() {
        if (singleton == null) {
            singleton = new UIIconFactories();
        }
        return singleton;
    }

    private UIIconFactories() {
        this.configure();
    }

    private void configure() {
        IConfigurationElement[] elements;
        logger.info((Object)"Initializing UIIconFactories...");
        this.factories = new CachedClassMap();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.ui.iconFactory");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            try {
                UIIconFactory factory = (UIIconFactory)element.createExecutableExtension("class");
                String targetClass = element.getAttribute("targetClass");
                this.factories.put(this.getClass().getClassLoader(), targetClass, factory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.info((Object)"UIActions initialized");
    }

    UIIconFactory getUIIconFactory(Object target) {
        LinkedHashMap<Class<?>, UIIconFactory> map;
        if (target != null && (map = this.factories.findBottomUp(target.getClass())).values().size() > 0) {
            return map.values().iterator().next();
        }
        return null;
    }

    UIIconFactory getUIIconFactoryForClass(Class clazz) {
        LinkedHashMap<Class<?>, UIIconFactory> map = this.factories.findBottomUp(clazz);
        if (map.values().size() > 0) {
            return map.values().iterator().next();
        }
        return null;
    }
}

