/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.UIAction;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIActions {
    private static final Logger logger = Logger.getLogger(UIActions.class);
    private HashMap<String, ArrayList<UIAction>> actions;
    private HashMap<String, ArrayList<UIAction>> cache = new HashMap();
    private static UIActions singleton;

    private static UIActions instance() {
        if (singleton == null) {
            singleton = new UIActions();
        }
        return singleton;
    }

    private UIActions() {
        this.configure();
    }

    private void configure() {
        IConfigurationElement[] elements;
        logger.info((Object)"Initializing UIActions...");
        this.actions = new HashMap();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.ui.actions");
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            UIAction uiAction = (UIAction)element.createExecutableExtension("class");
            uiAction.setName(element.getAttribute("name"));
            String targetClass = element.getAttribute("targetClass");
            ArrayList<UIAction> uiActions = this.actions.get(targetClass);
            if (uiActions == null) {
                uiActions = new ArrayList();
                this.actions.put(targetClass, uiActions);
            }
            uiActions.add(uiAction);
        }
        UIActionComparator comparator = new UIActionComparator();
        for (ArrayList<UIAction> uiActions : this.actions.values()) {
            Collections.sort(uiActions, comparator);
        }
        logger.info((Object)"UIActions initialized");
    }

    public static List<UIAction> getActionForTarget(Object target) {
        return UIActions.instance().getActionForTargetImpl(target);
    }

    private List<UIAction> getActionForTargetImpl(Object object) {
        return this.getActionsForClassImpl(object.getClass());
    }

    private List<UIAction> getActionsForClassImpl(Class targetClass) {
        String className = targetClass.getName();
        ArrayList<UIAction> ret = this.cache.get(className);
        if (ret == null) {
            ret = new ArrayList();
            do {
                List<UIAction> superClassActions = this.getActionsForClassImpl(targetClass);
                for (UIAction uiAction : superClassActions) {
                    if (ret.contains(uiAction)) continue;
                    ret.add(uiAction);
                }
            } while ((targetClass = targetClass.getSuperclass()) != null);
            Collections.sort(ret, new UIActionComparator());
            this.cache.put(className, ret);
        }
        return ret;
    }

    private List<UIAction> getActionsForClassNameImpl(String className) {
        return this.actions.get(className);
    }

    private static JMenu asJMenu(Object target) {
        List<UIAction> uiActions = UIActions.getActionForTarget(target);
        JMenu ret = new JMenu();
        String category = null;
        for (UIAction uiAction : uiActions) {
            if (category == null) {
                category = uiAction.category.name;
            } else if (!uiAction.category.name.equals(category)) {
                category = uiAction.category.name;
                ret.addSeparator();
            }
            JMenuItem menuItem = new JMenuItem(uiAction.getName());
            menuItem.setEnabled(uiAction.isEnabled(target));
            menuItem.addActionListener(uiAction.createActionListener(target));
            ret.add(menuItem);
        }
        return ret;
    }

    private static List<JButton> asJButtons(Class baseClass) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UIActionComparator
    implements Comparator<UIAction> {
        private UIActionComparator() {
        }

        @Override
        public int compare(UIAction o1, UIAction o2) {
            if (o1.category.priority < o2.category.priority) {
                return -1;
            }
            if (o1.category.priority > o2.category.priority) {
                return 1;
            }
            if (o1.position < o2.position) {
                return -1;
            }
            if (o1.position > o2.position) {
                return 1;
            }
            return 0;
        }
    }
}

