/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.Internationalizer;
import com.bwanms.ui.components.ComboItem;
import java.awt.Component;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SwingInternationalizer {
    private Internationalizer i18n;

    public SwingInternationalizer(Internationalizer i18n) {
        this.i18n = i18n;
    }

    public void translateComponent(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (jComponent.getBorder() != null) {
                this.translateBorder(jComponent.getBorder());
            }
            this.translateToolTip(jComponent);
        }
        if (component instanceof JPanel) {
            this.translateContainer((Container)component);
        }
        if (component instanceof JScrollPane) {
            this.translateContainer((Container)component);
        }
        if (component instanceof JViewport) {
            this.translateContainer((Container)component);
        } else if (component instanceof JLabel) {
            this.translateJLabel((JLabel)component);
        } else if (component instanceof AbstractButton) {
            this.translateAbstractButton((AbstractButton)component);
        } else if (component instanceof JSplitPane) {
            this.translateComponent(((JSplitPane)component).getLeftComponent());
            this.translateComponent(((JSplitPane)component).getRightComponent());
        } else if (component instanceof JTabbedPane) {
            JTabbedPane panel = (JTabbedPane)component;
            for (Component tab : panel.getComponents()) {
                this.translateComponent(tab);
            }
            for (int i = 0; i < panel.getTabCount(); ++i) {
                panel.setTitleAt(i, this.i18n.translateString(panel.getTitleAt(i)));
            }
        }
    }

    private void translateToolTip(JComponent component) {
        if (null != component.getToolTipText()) {
            component.setToolTipText(this.i18n.translateString(component.getToolTipText()));
        }
    }

    private void translateBorder(Border border) {
        if (border instanceof TitledBorder) {
            TitledBorder tBorder = (TitledBorder)border;
            tBorder.setTitle(this.i18n.translateString(tBorder.getTitle()));
        }
    }

    public void translateContainer(Container container) {
        for (Component component : container.getComponents()) {
            this.translateComponent(component);
        }
    }

    private void translateJLabel(JLabel label) {
        label.setText(this.i18n.translateString(label.getText()));
    }

    private void translateAbstractButton(AbstractButton button) {
        button.setText(this.i18n.translateString(button.getText()));
    }

    public void translateJMenu(JMenu jMenu) {
        for (Component component : jMenu.getMenuComponents()) {
            if (!(component instanceof JMenuItem)) continue;
            this.translateJMenuItem((JMenuItem)component);
        }
    }

    public void translateJPopupMenu(JPopupMenu jMenu) {
        for (Component component : jMenu.getComponents()) {
            if (!(component instanceof JMenuItem)) continue;
            this.translateJMenuItem((JMenuItem)component);
        }
    }

    public void translateJMenuItem(JMenuItem jMenuItem) {
        jMenuItem.setText(this.i18n.translateString(jMenuItem.getText()));
    }

    public void translateCombo(JComboBox combo) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!(combo.getItemAt(i) instanceof ComboItem)) continue;
            ComboItem comboItem = (ComboItem)combo.getItemAt(i);
            comboItem.setText(this.i18n.translateString(comboItem.getText()));
        }
    }

    public void translateJToolBar(JToolBar toolBar) {
        for (Component component : toolBar.getComponents()) {
            this.translateComponent(component);
        }
    }

    public ComboItem translateComboItem(ComboItem comboItem) {
        comboItem.setText(this.i18n.translateString(comboItem.getText()));
        return comboItem;
    }
}

