/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.SelectorFactory;
import com.bwanms.gui.SelectorView;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.CachedClassMap;
import java.io.Serializable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selectors {
    private static final Logger logger = Logger.getLogger(Selectors.class);
    private static Selectors instance;
    private CachedClassMap<SelectorFactory> factories;

    private static Selectors instance() {
        if (instance == null) {
            instance = new Selectors();
        }
        return instance;
    }

    public static <T extends Serializable> SelectorView<T> getSelectorView(Class<? extends T> baseClass, String userData) {
        return Selectors.getSelectorView(baseClass, null, userData);
    }

    public static <T extends Serializable> SelectorView<T> getSelectorView(Class<? extends T> baseClass, String selectorName, String userData) {
        return Selectors.instance().getSelectorViewImpl(baseClass, selectorName, userData);
    }

    private Selectors() {
        this.configure();
    }

    private void configure() {
        logger.info((Object)"Initializing Selectors...");
        this.factories = new CachedClassMap();
        try {
            IConfigurationElement[] elements;
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.ui.selectors");
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                try {
                    SelectorFactory factory = (SelectorFactory)element.createExecutableExtension("class");
                    String targetClass = element.getAttribute("targetClass");
                    this.factories.put(this.getClass().getClassLoader(), targetClass, factory);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.info((Object)"Selectors initialized");
    }

    public <T extends Serializable> SelectorView<T> getSelectorViewImpl(Class<? extends T> baseClass, String selectorName, String userData) {
        SelectorFactory factory = this.factories.findBottomUp(baseClass).values().iterator().next();
        return factory.createSelector(baseClass, selectorName, userData);
    }
}

