/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.SelectorView;
import com.bwanms.gui.SelfContainedSelectorView;
import com.bwanms.gui.selectors.MultipleEnumSelectorView;
import com.bwanms.gui.selectors.SelectorDialog;
import com.bwanms.gui.selectors.SelectorListComponent;
import com.bwanms.gui.selectors.SelfContainedSelectorDialog;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.constants.EventFilterConstantsProvider;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.util.FrameUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorUtil {
    public static void displayModalSelector(JComponent parent, SelectorView selector) {
        Window parentWindow = SwingUtilities.getWindowAncestor(parent);
        if (selector instanceof SelfContainedSelectorView) {
            SelfContainedSelectorDialog dialog;
            if (parentWindow instanceof JFrame) {
                dialog = new SelfContainedSelectorDialog((JFrame)parentWindow);
            } else if (parentWindow instanceof JDialog) {
                dialog = new SelfContainedSelectorDialog((JDialog)parentWindow);
            } else {
                throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
            }
            dialog.setSelectorView((SelfContainedSelectorView)selector);
            SelectorUtil.setWindowClosingEvent(dialog, selector);
            dialog.setModal(true);
            dialog.setTitle(selector.getTitle());
            dialog.setPreferredSize(new Dimension(selector.getUI().getPreferredSize().width + 10, selector.getUI().getPreferredSize().height + 70));
            dialog.pack();
            SelectorUtil.centerDialog(dialog);
            dialog.setVisible(true);
        } else {
            SelectorDialog dialog;
            if (parentWindow instanceof JFrame) {
                dialog = new SelectorDialog((JFrame)parentWindow);
            } else if (parentWindow instanceof JDialog) {
                dialog = new SelectorDialog((JDialog)parentWindow);
            } else {
                throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
            }
            SelectorUtil.setWindowClosingEvent(dialog, selector);
            dialog.setSelectorView(selector);
            dialog.setModal(true);
            dialog.setTitle(selector.getTitle());
            dialog.pack();
            dialog.setResizable(true);
            SelectorUtil.centerDialog(dialog);
            dialog.setVisible(true);
        }
    }

    private static void setWindowClosingEvent(Window window, final SelectorView selector) {
        window.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                selector.clearSelection();
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public static void display2ModalSelector(JComponent parent, SelectorView selector) {
        if (selector instanceof SelfContainedSelectorView) {
            SelfContainedSelectorDialog dialog = new SelfContainedSelectorDialog((JDialog)SwingUtilities.getWindowAncestor(parent));
            dialog.setSelectorView((SelfContainedSelectorView)selector);
            SelectorUtil.setWindowClosingEvent(dialog, selector);
            dialog.setModal(true);
            dialog.setTitle(selector.getTitle());
            dialog.pack();
            SelectorUtil.centerDialog(dialog);
            dialog.setVisible(true);
        } else {
            SelectorDialog dialog = new SelectorDialog((JDialog)SwingUtilities.getWindowAncestor(parent));
            dialog.setSelectorView(selector);
            SelectorUtil.setWindowClosingEvent(dialog, selector);
            dialog.setModal(true);
            dialog.setTitle(selector.getTitle());
            dialog.pack();
            SelectorUtil.centerDialog(dialog);
            dialog.setVisible(true);
        }
    }

    private static void centerDialog(JDialog dialog) {
        int maxWidth = (int)dialog.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)dialog.getGraphicsConfiguration().getBounds().getHeight();
        int width = dialog.getWidth();
        int height = dialog.getHeight();
        dialog.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
    }

    public static void displaySelfContainedSelectorDialog(JComponent parent, SelectorView selector) {
        SelfContainedSelectorDialog dialog;
        Window parentWindow = SwingUtilities.getWindowAncestor(parent);
        if (parentWindow instanceof JFrame) {
            dialog = new SelfContainedSelectorDialog((JFrame)parentWindow);
        } else if (parentWindow instanceof JDialog) {
            dialog = new SelfContainedSelectorDialog((JDialog)parentWindow);
        } else {
            throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
        }
        dialog.setSelectorView((SelfContainedSelectorView)selector);
        SelectorUtil.setWindowClosingEvent(dialog, selector);
        dialog.setModal(true);
        dialog.setTitle(selector.getTitle());
        dialog.setPreferredSize(new Dimension(selector.getUI().getPreferredSize().width + 10, selector.getUI().getPreferredSize().height + 70));
        dialog.pack();
        SelectorUtil.centerDialog(dialog);
        dialog.setVisible(true);
    }

    public static void closeWithEsc(final MultipleEnumSelectorView selectorView) {
        KeyAdapter theListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    selectorView.clearSelection();
                    JDialog dialog = (JDialog)selectorView.getUI().getTopLevelAncestor();
                    dialog.dispose();
                }
            }
        };
        FrameUtil.addKeyListenerRecursively(selectorView.getUI(), theListener);
    }

    public static void doubleClickExit(int clickCount, JComponent component) {
        if (clickCount == 2) {
            try {
                SelectorDialog selDialog = (SelectorDialog)component.getTopLevelAncestor();
                selDialog.dispose();
            }
            catch (ClassCastException cca) {
                cca.printStackTrace();
            }
        }
    }

    public static List<EventFilterConstantsProvider> loadConstantsProviders() {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.eventFilterConstantsProvider");
        ArrayList<EventFilterConstantsProvider> constProviders = new ArrayList<EventFilterConstantsProvider>(extensionPoint.getConfigurationElements().length);
        for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
            String className = element.getAttribute("class");
            try {
                Class<?> clazz = Class.forName(className);
                constProviders.add((EventFilterConstantsProvider)clazz.newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return constProviders;
    }

    public static void neTypeSelectorValueChanged(PropertyChangeEvent e, SelectorListComponent neListSelector) {
        List selectedNEList = (List)neListSelector.getValue();
        if (selectedNEList != null) {
            ArrayList newNEList = new ArrayList(selectedNEList);
            List newConstList = (List)e.getNewValue();
            List oldConstList = (List)e.getOldValue();
            if (oldConstList != null && newConstList != null) {
                for (Enum oldConst : oldConstList) {
                    if (newConstList.contains(oldConst)) continue;
                    for (Equipment equipment : selectedNEList) {
                        try {
                            Method m = oldConst.getClass().getMethod("type", new Class[0]);
                            Class clazz = (Class)m.invoke((Object)oldConst, new Object[0]);
                            if (!equipment.getClass().equals(clazz)) continue;
                            newNEList.remove(equipment);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                neListSelector.setValue(new ArrayList(newNEList));
            }
        }
    }
}

