/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.DefaultFormatter;

public class RegexFormatter
extends DefaultFormatter {
    private static final long serialVersionUID = -7254050318949266623L;
    public static final String RbIdRegex = "((\\d?|\\d\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){5}(\\d?|\\d\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
    public static final String RbPartialMacRegex = "(\\p{XDigit}{2}-){0,5}(\\p{XDigit}{0,2})";
    public static final String RbFinalMacRegex = "((\\p{XDigit}{2}-){5}(\\p{XDigit}{2}))?";
    public static final String RbPartialMacMaskRegex = "(?i)(ff-){0,5}(f[fec80]?|[ec8]0?)?|(ff-){0,4}(f[fec80]|[ec80]0)-0{0,2}|(ff-){0,3}(f[ec80]|[ec80]0)(-00)?-0{0,2}|(ff-){0,2}(f[ec80]|[ec80]0)(-00){0,2}-0{0,2}|ff-(f[fec80]|[ec80]0)(-00){0,3}-0{0,2}|(f[fec80]|[ec80]0)(-00){0,4}-0{0,2}";
    public static final String RbFinalMacMaskRegex = "(?i)((ff-){5}(f[fec80]|[ec80]0)|(ff-){4}(f[fec80]|[ec80]0)-00|(ff-){3}(f[fec80]|[ec80]0)(-00){2}|(ff-){2}(f[fec80]|[ec80]0)(-00){3}|ff-(f[fec80]|[ec80]0)(-00){4}|(f[fec80]|[ec8]0)(-00){5})?";
    public static final String RbPartialIpMaskRegex = "(255\\.){0,3}(2(5[245]?)?|2(4[08]?)?|2(24?)?|1(92?)?|1(28?)?|0)?|(255\\.){0,2}(25[24]|24[08]|224|192|128|0)\\.0?|255\\.(25[24]|24[08]|224|192|128|0)\\.0\\.0?|(25[24]|24[08]|224|192|128|0)(\\.0){0,2}\\.0?";
    public static final String RbFinalIpMaskRegex = "((255\\.){3}(25[245]|24[08]|224|192|128|0)|(255\\.){2}(25[24]|24[08]|224|192|128|0)\\.0|255\\.(25[24]|24[08]|224|192|128|0)(\\.0){2}|(25[24]|24[08]|224|192|128|0)(\\.0){3})?";
    public static final String RbPartialIpRegex = "(([0-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){0,2}(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])?)?|254\\.255\\.255\\.255|[1-9]?|[aA]|[aA][nN]|[aA][nN][yY])";
    public static final String PartialIpRegex = "(([0-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){0,2}(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])?)?|254\\.255\\.255\\.255|[1-9]?)";
    public static final String RbFinalIpRegex = "((([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-4])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|254\\.255\\.255\\.255))?";
    public static final String FinalIpRegex = "(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-4])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|254\\.255\\.255\\.255))?";
    private Pattern pattern;
    private Matcher matcher;

    public RegexFormatter() {
        this.setOverwriteMode(false);
        this.setAllowsInvalid(false);
        this.setCommitsOnValidEdit(true);
    }

    public RegexFormatter(String pattern) throws PatternSyntaxException {
        this();
        this.setPattern(Pattern.compile(pattern));
    }

    public RegexFormatter(Pattern pattern) {
        this();
        this.setPattern(pattern);
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    public Object stringToValue(String text) throws ParseException {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            Matcher matcher = pattern.matcher(text);
            if (matcher.matches()) {
                this.setMatcher(matcher);
                return super.stringToValue(text);
            }
            throw new ParseException("Pattern did not match", 0);
        }
        return text;
    }
}

