/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.gui;

import com.bwanms.gui.SwingInternationalizer;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.ui.components.ComboItem;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Internationalizer {
    private static final Logger logger = Logger.getLogger(Internationalizer.class);
    private static TreeMap<String, Internationalizer> i18ns = null;
    private static ArrayList<String> reverseIDs = null;
    private static Locale locale = Locale.getDefault();
    private ArrayList<ResourceBundle> resourceBundles = new ArrayList();
    private HashSet<String> keys = new HashSet();
    private String name;
    private static Internationalizer masterI18N = null;

    public static Internationalizer getInternationalizer(String name) {
        if (i18ns == null) {
            try {
                Internationalizer.configure();
            }
            catch (Exception e) {
                logger.info((Object)"Error initializing internationalizer", (Throwable)e);
            }
        }
        if (i18ns.keySet().contains(name + ".")) {
            return i18ns.get(name + ".");
        }
        Internationalizer ret = Internationalizer.loadInternationalizer(name);
        if (ret == null) {
            ret = Internationalizer.getConfiguredInternationalizer(name);
        }
        return ret;
    }

    public static Internationalizer getInternationalizer(Class clazz) {
        return Internationalizer.getInternationalizer(clazz.getName());
    }

    public static Internationalizer getSimpleInternationalizer(Class clazz) {
        i18ns = new TreeMap();
        String name = clazz.getName();
        if (i18ns.keySet().contains(name + ".")) {
            return i18ns.get(name + ".");
        }
        Internationalizer ret = Internationalizer.loadInternationalizer(name);
        if (ret == null) {
            ret = Internationalizer.getConfiguredInternationalizer(name);
        }
        return ret;
    }

    private static Internationalizer getConfiguredInternationalizer(String name) {
        for (String id : reverseIDs) {
            if (!name.startsWith(id)) continue;
            return i18ns.get(id);
        }
        return null;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String translateString(String key) {
        if (key == null) {
            logger.error((Object)("Can't get translation for [" + key + "]."));
            return null;
        }
        if ("".equals(key)) {
            return key;
        }
        if (masterI18N != null && this != masterI18N && masterI18N.canTranslate(key)) {
            return masterI18N.translateString(key);
        }
        for (ResourceBundle bundle : this.resourceBundles) {
            try {
                return bundle.getString(key).trim();
            }
            catch (MissingResourceException e) {
            }
            catch (Throwable e) {
                logger.error((Object)("Can't get translation for [" + key + "]."), e);
            }
        }
        logger.debug((Object)("I18N [" + this.name + "] not found: " + key));
        return "*" + key + "*";
    }

    public boolean canTranslate(String key) {
        if (key == null) {
            logger.error((Object)("Can't get translation for [" + key + "]."));
            return false;
        }
        return this.keys.contains(key);
    }

    public String translateString(String key, Object ... arguments) {
        String translatedKey = this.translateString(key);
        return String.format(translatedKey, arguments);
    }

    @Deprecated
    public void translateCombo(JComboBox combo) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!(combo.getItemAt(i) instanceof ComboItem)) continue;
            ComboItem comboItem = (ComboItem)combo.getItemAt(i);
            comboItem.setText(this.translateString(comboItem.getText()));
        }
    }

    private static void generateReverseIDs() {
        reverseIDs.clear();
        for (String id : i18ns.keySet()) {
            reverseIDs.add(0, id);
        }
    }

    private static Internationalizer loadInternationalizer(String name) {
        try {
            int lastDotIndex = name.lastIndexOf(46);
            String packageName = lastDotIndex > 0 ? name.substring(0, lastDotIndex) : "";
            String baseName = lastDotIndex > 0 ? packageName + ".Resources" : name;
            ResourceBundle bundle = ResourceBundle.getBundle(baseName);
            if (bundle == null && !baseName.equals(name)) {
                baseName = name;
                bundle = ResourceBundle.getBundle(baseName);
            }
            if (bundle != null) {
                Internationalizer ret = new Internationalizer();
                ret.setName(baseName);
                ret.addBundle(bundle);
                return ret;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"loadInternationalizer error: ", (Throwable)e);
        }
        return null;
    }

    private void addBundle(ResourceBundle bundle) {
        this.resourceBundles.add(bundle);
        Enumeration<String> bundleKeys = bundle.getKeys();
        while (bundleKeys.hasMoreElements()) {
            this.keys.add(bundleKeys.nextElement());
        }
    }

    private static void configure() {
        IConfigurationElement[] elements;
        i18ns = new TreeMap();
        reverseIDs = new ArrayList();
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.i18n");
        if (extensionPoint == null) {
            throw new RuntimeException("com.bwanms.i18n extension point not defined");
        }
        for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
            String targetBundle = element.getAttribute("target");
            if (targetBundle == null) {
                targetBundle = element.getNamespace();
            }
            String bundleName = element.getAttribute("bundle");
            Internationalizer.configureBundle(targetBundle, bundleName);
        }
        masterI18N = i18ns.get("com.bwanms.i18n.master.");
    }

    public ResourceBundle asBundle() {
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return Internationalizer.this.translateString(key);
            }

            @Override
            public Enumeration<String> getKeys() {
                final Iterator keySetIterator = Internationalizer.this.keys.iterator();
                return new Enumeration<String>(){

                    @Override
                    public boolean hasMoreElements() {
                        return keySetIterator.hasNext();
                    }

                    @Override
                    public String nextElement() {
                        return (String)keySetIterator.next();
                    }
                };
            }
        };
    }

    private static void configureBundle(String key, String basename) {
        ResourceBundle bundle = ResourceBundle.getBundle(basename, locale);
        if (bundle == null) {
            throw new RuntimeException("Bundle not found: " + basename);
        }
        String dottedKey = key + ".";
        Internationalizer i18n = i18ns.get(dottedKey);
        if (i18n == null) {
            i18n = new Internationalizer();
            i18n.setName(key);
            i18ns.put(dottedKey, i18n);
            Internationalizer.generateReverseIDs();
        }
        i18n.addBundle(bundle);
    }

    public SwingInternationalizer getSwingInternationalizer() {
        return new SwingInternationalizer(this);
    }

    public static final Locale getLocale() {
        return locale;
    }

    public void translateComboItemsList(List<ComboItem> items) {
        for (int i = 0; i < items.size(); ++i) {
            ComboItem item = items.get(i);
            item.setText(this.translateString(item.getText()));
            items.set(i, item);
        }
    }
}

